/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.apache.airavata.xbaya.ui.widgets.amazon.S3Tree;
import org.apache.airavata.xbaya.ui.widgets.amazon.S3TreeModel;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

public class BucketsLoader
implements Cancelable {
    private XBayaGUI xbayaGUI;
    private JDialog parent;
    private boolean canceled;
    private WaitDialog loadingDialog;

    public BucketsLoader(XBayaGUI xbayaGUI, JDialog parent) {
        this.xbayaGUI = xbayaGUI;
        this.parent = parent;
        this.loadingDialog = new WaitDialog(this, "Loading S3 Buckets.", "Loading S3 Buckets.\nPlease wait for a moment.", this.xbayaGUI);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public void load(final S3Service s3, final S3Tree s3Tree) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    S3Bucket[] bucketArray;
                    for (S3Bucket s3Bucket : bucketArray = s3.listAllBuckets()) {
                        S3Object[] s3ObjectArray;
                        DefaultMutableTreeNode tempTreeNode = s3Tree.addObject((DefaultMutableTreeNode)null, (Object)s3Bucket.getName());
                        if (BucketsLoader.this.canceled) {
                            return;
                        }
                        for (S3Object s3Object : s3ObjectArray = s3.listObjects(s3Bucket.getName())) {
                            String keyName = s3Object.getName();
                            if (keyName.contains("$")) {
                                keyName = keyName.substring(0, keyName.indexOf(95));
                            }
                            s3Tree.addObject(tempTreeNode, (Object)keyName);
                        }
                    }
                    s3Tree.refresh();
                    if (bucketArray.length == 0) {
                        JOptionPane.showMessageDialog(BucketsLoader.this.parent, "Connection Failed!", "Error", 0);
                        return;
                    }
                    JOptionPane.showMessageDialog(BucketsLoader.this.parent, "Connection Successfully!", "Info", 1);
                    S3TreeModel.getInstance().connect();
                }
                catch (S3ServiceException ex) {
                    BucketsLoader.this.xbayaGUI.getErrorWindow().error((Component)BucketsLoader.this.parent, "Cannot List S3 buckets", ex);
                }
                finally {
                    BucketsLoader.this.loadingDialog.hide();
                }
            }
        }).start();
        this.loadingDialog.show();
    }
}

