/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class XBayaDialog {
    private Window owner;
    private String title;
    private String description;
    private JDialog dialog;
    private JComponent mainPanel;
    private JComponent buttonPanel;

    public XBayaDialog(XBayaGUI xbayaGUI, String title, XBayaComponent mainPanel, XBayaComponent buttonPanel) {
        this((Window)xbayaGUI.getFrame(), title, mainPanel.getSwingComponent(), buttonPanel.getSwingComponent());
    }

    public XBayaDialog(XBayaGUI xbayaGUI, String title, XBayaComponent mainPanel, JComponent buttonPanel) {
        this((Window)xbayaGUI.getFrame(), title, mainPanel.getSwingComponent(), buttonPanel);
    }

    public XBayaDialog(XBayaGUI xbayaGUI, String title, String description, XBayaComponent mainPanel, JComponent buttonPanel) {
        this(xbayaGUI.getFrame(), title, description, mainPanel.getSwingComponent(), buttonPanel);
    }

    public XBayaDialog(XBayaGUI xbayaGUI, String title, JComponent mainPanel, JComponent buttonPanel) {
        this((Window)xbayaGUI.getFrame(), title, mainPanel, buttonPanel);
    }

    public XBayaDialog(Window owner, String title, XBayaComponent mainPanel, JComponent buttonPanel) {
        this(owner, title, mainPanel.getSwingComponent(), buttonPanel);
    }

    public XBayaDialog(Window owner, String title, JComponent mainPanel, JComponent buttonPanel) {
        this(owner, title, null, mainPanel, buttonPanel);
    }

    public XBayaDialog(Window owner, String title, String description, JComponent mainPanel, JComponent buttonPanel) {
        this.owner = owner;
        this.title = title;
        this.description = description;
        this.mainPanel = mainPanel;
        this.buttonPanel = buttonPanel;
        this.init();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void show() {
        int height;
        this.dialog.pack();
        Dimension size = this.dialog.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int inset = 100;
        int width = size.width;
        if (width > screenSize.width) {
            width = screenSize.width - 100;
        }
        if ((height = size.height) > screenSize.height) {
            height = screenSize.height - 100;
        }
        this.dialog.setSize(width, height);
        this.dialog.setLocationRelativeTo(this.owner);
        this.dialog.setVisible(true);
    }

    public void simpeShow() {
        this.dialog.setVisible(true);
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    public void setTitle(String title) {
        this.title = title;
        this.dialog.setTitle(title);
    }

    public void setDefaultButton(JButton button) {
        this.dialog.getRootPane().setDefaultButton(button);
    }

    public void setCancelButton(final JButton button) {
        this.dialog.getRootPane().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    button.getAction().actionPerformed(null);
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
    }

    private void init() {
        if (this.owner instanceof Frame) {
            this.dialog = new JDialog((Frame)this.owner);
        } else if (this.owner instanceof Dialog) {
            this.dialog = new JDialog((Dialog)this.owner);
        } else {
            throw new WorkflowRuntimeException("The owner component was neither Frame or Dialog.");
        }
        this.dialog.setTitle(this.title);
        this.dialog.setModal(true);
        this.dialog.setResizable(true);
        Container contentPane = this.dialog.getContentPane();
        int numRow = 0;
        if (this.description != null && this.description.length() > 0) {
            JLabel descriptionLabel = new JLabel("<html>" + this.description + "</html>");
            contentPane.add(descriptionLabel);
            ++numRow;
        }
        contentPane.add(this.mainPanel);
        ++numRow;
        contentPane.add(this.buttonPanel);
        SwingUtil.layoutToGrid((Container)contentPane, (int)(++numRow), (int)1, (int)(numRow - 2), (int)0);
    }
}

