/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitDialog {
    private static final Logger logger = LoggerFactory.getLogger(WaitDialog.class);
    private XBayaGUI xbayaGUI;
    private Cancelable cancelable;
    private String title;
    private String message;
    private XBayaDialog dialog;
    private boolean done;

    public WaitDialog(Cancelable cancelable, String title, String message, XBayaGUI xbayaGUI) {
        this.cancelable = cancelable;
        this.title = title;
        this.message = message;
        this.xbayaGUI = xbayaGUI;
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        WaitDialog waitDialog = this;
        synchronized (waitDialog) {
            this.done = false;
            if (this.dialog == null) {
                this.initGUI();
            }
        }
        this.dialog.show();
    }

    public synchronized void hide() {
        if (this.done) {
            return;
        }
        while (this.dialog == null || !this.dialog.getDialog().isVisible()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.done = true;
        this.dialog.hide();
    }

    private void initGUI() {
        JLabel label = new JLabel(this.message, 0);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitDialog.this.dialog.hide();
                WaitDialog.this.cancelable.cancel();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, this.title, (JComponent)label, (JComponent)buttonPanel);
        this.dialog.getDialog().setDefaultCloseOperation(0);
        this.dialog.getDialog().setCursor(SwingUtil.WAIT_CURSOR);
        this.dialog.getDialog().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WaitDialog.this.shown();
            }
        });
    }

    private synchronized void shown() {
        this.notifyAll();
    }
}

