/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.airavata.common.utils.BrowserLauncher;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextWindow {
    private static final Logger logger = LoggerFactory.getLogger(TextWindow.class);
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private String key;
    private String value;
    private String title;

    public TextWindow(XBayaEngine engine, String key, String value, String title) {
        this.engine = engine;
        this.key = key;
        this.value = value;
        this.title = title;
        this.init();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void init() {
        final JEditorPane editorPane = new JEditorPane("application/xhtml+xml;charset=utf-8", this.value);
        editorPane.setEditable(false);
        editorPane.setBackground(Color.WHITE);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                logger.debug("Event:" + event);
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = event.getURL();
                    try {
                        BrowserLauncher.openURL((String)url.toString());
                    }
                    catch (Exception e) {
                        TextWindow.this.engine.getGUI().getErrorWindow().error((Component)TextWindow.this.dialog.getDialog(), e.getMessage(), e);
                    }
                }
            }
        });
        JScrollPane pane = new JScrollPane(editorPane);
        GridPanel gridPanel = new GridPanel();
        XBayaTextField txtKey = new XBayaTextField(this.key);
        txtKey.getTextField().setEditable(false);
        gridPanel.add(txtKey);
        gridPanel.add(pane);
        gridPanel.getContentPanel().setBorder(BorderFactory.createEtchedBorder());
        gridPanel.layout(2, 1, 1, 0);
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("Close");
        okButton.setDefaultCapable(true);
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextWindow.this.hide();
            }
        });
        JButton btnCopy = new JButton("Copy to clipboard");
        btnCopy.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(editorPane.getText()), null);
            }
        });
        buttonPanel.add(btnCopy);
        buttonPanel.add(okButton);
        buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dialog = new XBayaDialog(this.engine.getGUI(), this.title, (XBayaComponent)gridPanel, (JComponent)buttonPanel);
        this.dialog.getDialog().setMinimumSize(new Dimension(400, 400));
        this.dialog.setDefaultButton(okButton);
    }
}

