/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.globus.GridFTPFileTransferClient;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.globusonline.transfer.APIError;
import org.globusonline.transfer.JSONTransferAPIClient;
import org.json.JSONException;

public class GlobusFileTransferWindow {
    public static final String GLOBUSONLINE_BASE_URL_V0_10 = "https://transfer.api.globusonline.org/v0.10";
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private XBayaTextField usernameTextField;
    private XBayaTextField caFileTextField;
    private XBayaTextField certFileTextField;
    private XBayaTextField keyFileTextField;
    private XBayaTextField sourceEndpointTextField;
    private XBayaTextField sourceFilePathTextField;
    private XBayaTextField destEndpointTextField;
    private XBayaTextField destFilePathTextField;

    public GlobusFileTransferWindow(XBayaEngine engine) {
        this.engine = engine;
        this.initGUI();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void ok() {
        JSONTransferAPIClient c;
        String username = this.usernameTextField.getText();
        String caFile = this.caFileTextField.getText();
        String certFile = this.certFileTextField.getText();
        String keyFile = this.keyFileTextField.getText();
        String sourceEndpoint = this.sourceEndpointTextField.getText();
        String sourceFilePath = this.sourceFilePathTextField.getText();
        String destEndpoint = this.destEndpointTextField.getText();
        String destFilePath = this.destFilePathTextField.getText();
        try {
            c = new JSONTransferAPIClient(username, caFile, certFile, keyFile, GLOBUSONLINE_BASE_URL_V0_10);
        }
        catch (KeyManagementException e) {
            this.engine.getGUI().getErrorWindow().error("Key Management Error.", e);
            return;
        }
        catch (NoSuchAlgorithmException e) {
            this.engine.getGUI().getErrorWindow().error("No Such Algorithm Error.", e);
            return;
        }
        System.out.println("base url: " + c.getBaseUrl());
        GridFTPFileTransferClient e = new GridFTPFileTransferClient(c);
        try {
            e.transfer(sourceEndpoint, sourceFilePath, destEndpoint, destFilePath);
        }
        catch (IOException e1) {
            this.engine.getGUI().getErrorWindow().error("IO Error.", e1);
            return;
        }
        catch (JSONException e1) {
            this.engine.getGUI().getErrorWindow().error("JSON Error.", e1);
            return;
        }
        catch (GeneralSecurityException e1) {
            this.engine.getGUI().getErrorWindow().error("Key Management Error.", e1);
            return;
        }
        catch (APIError apiError) {
            this.engine.getGUI().getErrorWindow().error("Globus Transfer API Calling Error.", apiError);
            return;
        }
        this.hide();
    }

    private void initGUI() {
        this.usernameTextField = new XBayaTextField();
        this.caFileTextField = new XBayaTextField();
        this.certFileTextField = new XBayaTextField();
        this.keyFileTextField = new XBayaTextField();
        this.sourceEndpointTextField = new XBayaTextField();
        this.sourceFilePathTextField = new XBayaTextField();
        this.destEndpointTextField = new XBayaTextField();
        this.destFilePathTextField = new XBayaTextField();
        XBayaLabel nameLabel = new XBayaLabel("Username", this.usernameTextField);
        XBayaLabel caFileLabel = new XBayaLabel("CA File", this.caFileTextField);
        XBayaLabel certFileLabel = new XBayaLabel("Certificate File", this.certFileTextField);
        XBayaLabel keyFileLabel = new XBayaLabel("Key File", this.keyFileTextField);
        XBayaLabel sourceEprLabel = new XBayaLabel("Source Endpoint", this.sourceEndpointTextField);
        XBayaLabel sourceFilePathLabel = new XBayaLabel("Source File Path", this.sourceFilePathTextField);
        XBayaLabel destEprLabel = new XBayaLabel("Destination Endpoint", this.destEndpointTextField);
        XBayaLabel destFilePathLabel = new XBayaLabel("Destination FIle path", this.destFilePathTextField);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(nameLabel);
        infoPanel.add(this.usernameTextField);
        infoPanel.add(caFileLabel);
        infoPanel.add(this.caFileTextField);
        infoPanel.add(certFileLabel);
        infoPanel.add(this.certFileTextField);
        infoPanel.add(keyFileLabel);
        infoPanel.add(this.keyFileTextField);
        infoPanel.add(sourceEprLabel);
        infoPanel.add(this.sourceEndpointTextField);
        infoPanel.add(sourceFilePathLabel);
        infoPanel.add(this.sourceFilePathTextField);
        infoPanel.add(destEprLabel);
        infoPanel.add(this.destEndpointTextField);
        infoPanel.add(destFilePathLabel);
        infoPanel.add(this.destFilePathTextField);
        infoPanel.layout(8, 2, -1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobusFileTransferWindow.this.ok();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobusFileTransferWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Globus file transfer", (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

