/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorWindow {
    private static final String DEFAULT_ERROR_TITLE = "Error";
    private static final String DEFAULT_WARNING_TITLE = "Warning";
    private static final String DEFAULT_INFORMATION_TITLE = "Information";
    private static final Logger logger = LoggerFactory.getLogger(ErrorWindow.class);
    private Component defaultParent;

    public ErrorWindow(Component parent) {
        this.defaultParent = parent;
    }

    public void error(String message) {
        this.error(null, null, message, null);
    }

    public void error(String message, Throwable e) {
        this.error(null, null, message, e);
    }

    public void error(Throwable e) {
        this.error(null, null, null, e);
    }

    public void error(Component parent, String message) {
        this.error(parent, null, message, null);
    }

    public void error(Component parent, String message, Throwable e) {
        this.error(parent, null, message, e);
    }

    public void error(Component parent, String title, String message) {
        this.error(parent, title, message, null);
    }

    public void error(Component parent, String title, String message, Throwable e) {
        logger.error(e == null ? message : e.getMessage(), e);
        if (parent == null) {
            parent = this.defaultParent;
        }
        if (title == null) {
            title = DEFAULT_ERROR_TITLE;
        }
        if (message == null && e != null) {
            message = this.messageSplitter(e.getMessage());
        }
        if (message == null) {
            message = "Unexpected error.";
        }
        this.showErrorDialog(parent, title, message, e);
    }

    public void warning(String message) {
        this.warning(null, null, message);
    }

    public void warning(Component parent, String title, String message) {
        if (parent == null) {
            parent = this.defaultParent;
        }
        if (title == null) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showWarningDialog(parent, title, message);
    }

    public void info(String message) {
        this.info(null, null, message);
    }

    public void info(Component parent, String title, String message) {
        if (parent == null) {
            parent = this.defaultParent;
        }
        if (title == null) {
            title = DEFAULT_INFORMATION_TITLE;
        }
        this.showInformationDialog(parent, title, message);
    }

    private void showErrorDialog(Component parent, String title, String message, Throwable e) {
        Object[] options = new String[]{"OK", "Detail"};
        int result = JOptionPane.showOptionDialog(parent, message, title, -1, 0, null, options, options[0]);
        if (result == 1) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (e != null) {
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            String stackTrace = stringWriter.toString();
            JLabel messageLabel = new JLabel(this.messageSplitter(message));
            XBayaTextArea textArea = new XBayaTextArea();
            textArea.setEditable(false);
            textArea.setSize(800, 600);
            textArea.setText(stackTrace);
            GridPanel mainPanel = new GridPanel();
            mainPanel.add(messageLabel);
            mainPanel.add(textArea);
            mainPanel.layout(2, 1, 1, 0);
            JButton okButton = new JButton("OK");
            okButton.setDefaultCapable(true);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(okButton);
            final XBayaDialog dialog = new XBayaDialog(SwingUtilities.getWindowAncestor(parent), title, (XBayaComponent)mainPanel, (JComponent)buttonPanel);
            okButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    dialog.hide();
                }
            });
            dialog.setDefaultButton(okButton);
            dialog.show();
        }
    }

    private void showWarningDialog(Component parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 2);
    }

    private void showInformationDialog(Component parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    private String messageSplitter(String message) {
        int interval = 150;
        char[] sAr = message.toCharArray();
        int i = 0;
        StringBuffer buffer = new StringBuffer("");
        if (sAr.length > interval) {
            do {
                String subString = "";
                subString = i + interval > message.length() ? message.substring(i, message.length()) : message.substring(i, i + interval);
                buffer.append(subString);
                if (subString.contains("\n")) continue;
                buffer.append("\n");
            } while ((i += interval) < sAr.length);
            return buffer.toString();
        }
        return message;
    }
}

