/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.airavata.common.utils.BrowserLauncher;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.XBayaVersion;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutWindow {
    private static final Logger logger = LoggerFactory.getLogger(AboutWindow.class);
    private XBayaEngine engine;
    private XBayaDialog dialog;

    public AboutWindow(XBayaEngine engine) {
        this.engine = engine;
        this.init();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void init() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.setDefaultCapable(true);
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutWindow.this.hide();
            }
        });
        buttonPanel.add(okButton);
        String styles = "<style type=\"text/css\">body {font-family:Arial, Helvetica, sans-serif}.centeredImage{\ttext-align:center;\tdisplay:block;}</style>";
        buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        String imgLogoTag = "";
        String imgHeadingTag = "<div style=\"width:100%;margin-right:10px;margin-left:10px;margin-top:5px;\" ><img src=\"" + SwingUtil.getImageURL((String)"airavata-title-text.png").toString() + "\" class=\".centeredImage\" /></div><br>";
        String projectNameText = "";
        String message = "<html>" + styles + "<body align=\"center\">" + "<div style=\"background-color:white;width:100%;margin-bottom:0px;\">" + projectNameText + imgHeadingTag + imgLogoTag + "</div><br><h2>" + "XBaya Dashboard" + "</h2>" + "Version: " + XBayaVersion.VERSION + "<br>" + "<a href='" + XBayaConstants.WEB_URL.toString() + "'>" + XBayaConstants.WEB_URL.toString() + "</a>" + "<br>&nbsp</body></html>";
        JEditorPane editorPane = new JEditorPane("text/html; charset=utf-8", message);
        editorPane.setEditable(false);
        editorPane.setBorder(BorderFactory.createEtchedBorder());
        editorPane.setBackground(buttonPanel.getBackground());
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                logger.debug("Event:" + event);
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = event.getURL();
                    try {
                        BrowserLauncher.openURL((String)url.toString());
                    }
                    catch (Exception e) {
                        AboutWindow.this.engine.getGUI().getErrorWindow().error((Component)AboutWindow.this.dialog.getDialog(), e.getMessage(), e);
                    }
                }
            }
        });
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Apache Airavata", (JComponent)editorPane, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

