/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.ws.monitor.event.Event;
import org.apache.airavata.ws.monitor.event.EventListener;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.generators.WorkflowFiler;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.ui.dialogs.ErrorWindow;
import org.apache.airavata.xbaya.ui.dialogs.workflow.WorkflowPropertyWindow;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasEvent;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasListener;
import org.apache.airavata.xbaya.ui.menues.XBayaMenu;
import org.apache.airavata.xbaya.ui.views.ComponentViewer;
import org.apache.airavata.xbaya.ui.views.JCRBrowserPanel;
import org.apache.airavata.xbaya.ui.views.MonitorPanel;
import org.apache.airavata.xbaya.ui.views.PortViewer;
import org.apache.airavata.xbaya.ui.widgets.ScrollPanel;
import org.apache.airavata.xbaya.ui.widgets.TabLabelButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaToolBar;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class XBayaGUI
implements EventListener,
XBayaExecutionModeListener {
    private static final Logger logger = LoggerFactory.getLogger(XBayaGUI.class);
    private static final int STATIC_MENU_ITEMS = 4;
    private XBayaEngine engine;
    private JFrame frame;
    private XBayaMenu menu;
    private List<GraphCanvas> graphCanvases = new LinkedList<GraphCanvas>();
    private PortViewer portViewer;
    private ComponentViewer componentViewer;
    private ComponentSelector componentSelector;
    private MonitorPanel monitorPane;
    private XBayaToolBar toolbar;
    private ErrorWindow errorWindow;
    private JTabbedPane rightBottomTabbedPane;
    private JTabbedPane graphTabbedPane;
    private boolean graphPanelMaximized;
    private int previousMainDividerLocation;
    private int previousRightDividerLocation;
    private JSplitPane mainSplitPane;
    private JSplitPane leftSplitPane;
    private JSplitPane rightSplitPane;
    private JTabbedPane componentTabbedPane;
    private ScrollPanel compTreeXBayapanel;
    private WorkflowFiler graphFiler;
    private WorkflowPropertyWindow workflowPropertiesWindow;
    private List<ChangeListener> tabChangeListeners = new ArrayList<ChangeListener>();
    private JCRBrowserPanel jcrBrowserPanel;

    public XBayaGUI(XBayaEngine engine) {
        this.engine = engine;
        this.engine.getMonitor().addEventListener((EventListener)this);
        this.graphFiler = new WorkflowFiler(engine);
        engine.getConfiguration().registerExecutionModeChangeListener(this);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    XBayaGUI.this.init();
                }
            });
        }
        catch (InterruptedException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public MonitorPanel getMonitorPane() {
        return this.monitorPane;
    }

    public ComponentSelector getComponentSelector() {
        return this.componentSelector;
    }

    public ErrorWindow getErrorWindow() {
        return this.errorWindow;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public List<GraphCanvas> getGraphCanvases() {
        return this.graphCanvases;
    }

    public GraphCanvas getGraphCanvas() {
        int index = this.graphTabbedPane.getSelectedIndex();
        if (index != -1) {
            return this.graphCanvases.get(index);
        }
        return null;
    }

    public XBayaToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new XBayaToolBar(this.engine);
        }
        return this.toolbar;
    }

    public GraphCanvas newGraphCanvas(boolean focus) {
        return this.newGraphCanvas(focus, false);
    }

    public GraphCanvas newGraphCanvas(boolean focus, boolean withID) {
        GraphCanvas newGraphCanvas = new GraphCanvas(this.engine);
        this.graphCanvases.add(newGraphCanvas);
        this.graphTabbedPane.addTab(newGraphCanvas.getWorkflow().getName(), newGraphCanvas.getSwingComponent());
        final int index = this.graphTabbedPane.getTabCount() - 1;
        TabLabelButton tabLabelButton = new TabLabelButton(this.graphTabbedPane, "Close this workflow");
        this.graphTabbedPane.setTabComponentAt(index, tabLabelButton);
        tabLabelButton.setCloseButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaGUI.this.removeGraphCanvasFromIndex(index);
            }
        });
        this.graphTabbedPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent event) {
            }

            @Override
            public void componentRemoved(ContainerEvent event) {
                List<GraphCanvas> graphCanvases = XBayaGUI.this.engine.getGUI().getGraphCanvases();
                for (GraphCanvas graphCanvas : graphCanvases) {
                    if (graphCanvas.getSwingComponent() != event.getComponent()) continue;
                    if (!graphCanvas.isWorkflowChanged()) break;
                    XBayaGUI.this.setFocus(graphCanvas);
                    if (JOptionPane.showConfirmDialog(null, "The workflow '" + graphCanvas.getWorkflow().getName() + "' has been modified. Save changes?", "Save Workflow", 0) != 0) break;
                    XBayaGUI.this.graphFiler.saveWorkflow(graphCanvas);
                    break;
                }
            }
        });
        if (focus) {
            this.setFocus(newGraphCanvas);
        }
        newGraphCanvas.addGraphCanvasListener(this.componentViewer);
        newGraphCanvas.addGraphCanvasListener(this.portViewer);
        newGraphCanvas.addGraphCanvasListener(new GraphCanvasListener(){

            @Override
            public void graphCanvasChanged(GraphCanvasEvent event) {
                GraphCanvasEvent.GraphCanvasEventType type = event.getType();
                final GraphCanvas graphCanvas = event.getGraphCanvas();
                final Workflow workflow = event.getWorkflow();
                switch (type) {
                    case GRAPH_LOADED: 
                    case NAME_CHANGED: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String name = workflow.getName();
                                this.updateTabTitle(graphCanvas, workflow);
                                XBayaGUI.this.setFrameName(name);
                            }
                        });
                        break;
                    }
                    case NODE_SELECTED: 
                    case INPUT_PORT_SELECTED: 
                    case OUTPUT_PORT_SELECTED: 
                    case WORKFLOW_CHANGED: {
                        this.updateTabTitle(graphCanvas, graphCanvas.getWorkflow());
                        XBayaGUI.this.setFrameName(workflow.getName());
                        for (ChangeListener listener : XBayaGUI.this.tabChangeListeners) {
                            try {
                                listener.stateChanged(null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                }
            }

            private void updateTabTitle(GraphCanvas graphCanvas, Workflow workflow) {
                int index = XBayaGUI.this.graphTabbedPane.indexOfComponent(graphCanvas.getSwingComponent());
                String newTitle = workflow.getName();
                if (graphCanvas.isWorkflowChanged()) {
                    newTitle = "*" + newTitle;
                }
                XBayaGUI.this.graphTabbedPane.setTitleAt(index, newTitle);
            }
        });
        if (withID) {
            this.getWorkflowPropertyWindow().show();
        }
        return newGraphCanvas;
    }

    public void setFocus(GraphCanvas graphCanvas) {
        this.graphTabbedPane.setSelectedComponent(graphCanvas.getSwingComponent());
    }

    public void selectOrCreateGraphCanvas(Workflow workflow) {
        GraphCanvas graphCanvas = null;
        for (GraphCanvas canvas : this.graphCanvases) {
            if (workflow != canvas.getWorkflow()) continue;
            graphCanvas = canvas;
        }
        if (graphCanvas == null) {
            graphCanvas = this.newGraphCanvas(true);
            graphCanvas.setWorkflow(workflow);
        } else {
            this.setFocus(graphCanvas);
        }
    }

    public void addWorkflowTabChangeListener(ChangeListener listener) {
        this.graphTabbedPane.addChangeListener(listener);
        this.tabChangeListeners.add(listener);
    }

    public void removeWorkflowTabChangeListener(ChangeListener listener) {
        this.graphTabbedPane.removeChangeListener(listener);
        this.tabChangeListeners.remove(listener);
    }

    public void closeGraphCanvas() {
        this.removeGraphCanvasFromIndex(this.graphTabbedPane.getSelectedIndex());
    }

    public boolean closeAllGraphCanvas() {
        while (this.graphTabbedPane.getTabCount() > 0) {
            if (this.removeGraphCanvasFromIndex(0)) continue;
            return false;
        }
        return true;
    }

    private boolean removeGraphCanvasFromIndex(int index) {
        boolean actionSuccess = true;
        if (this.graphTabbedPane.getTabCount() > 0 && index < this.graphTabbedPane.getTabCount()) {
            GraphCanvas graphCanvas = this.graphCanvases.get(index);
            if (graphCanvas.isWorkflowChanged()) {
                int result = JOptionPane.showConfirmDialog(this.frame, "'" + graphCanvas.getWorkflow().getName() + "' has been modified. Save changes?", "Save Workflow", 1);
                try {
                    if (result == 0) {
                        this.graphFiler.saveWorkflow(graphCanvas);
                        if (graphCanvas.isWorkflowChanged()) {
                            actionSuccess = false;
                        }
                    } else if (result == 2) {
                        actionSuccess = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (actionSuccess) {
                this.graphCanvases.remove(index);
                this.graphTabbedPane.removeTabAt(index);
                this.activeTabChanged();
            }
        }
        return actionSuccess;
    }

    public void selectNextGraphCanvas() {
        int count = this.graphTabbedPane.getTabCount();
        int index = this.graphTabbedPane.getSelectedIndex();
        index = (index + 1) % count;
        this.graphTabbedPane.setSelectedIndex(index);
    }

    public void toggleMaximizeGraphPanel() {
        if (this.graphPanelMaximized) {
            this.unmaximizeGraphPanel();
        } else {
            this.maximizeGraphPanel();
        }
    }

    public void maximizeGraphPanel() {
        if (!this.graphPanelMaximized) {
            this.graphPanelMaximized = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XBayaGUI.this.previousMainDividerLocation = XBayaGUI.this.mainSplitPane.getDividerLocation();
                    XBayaGUI.this.previousRightDividerLocation = XBayaGUI.this.rightSplitPane.getDividerLocation();
                    XBayaGUI.this.mainSplitPane.setDividerLocation(0.0);
                    XBayaGUI.this.rightSplitPane.setDividerLocation(1.0);
                }
            });
        }
    }

    public void unmaximizeGraphPanel() {
        if (this.graphPanelMaximized) {
            this.graphPanelMaximized = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XBayaGUI.this.mainSplitPane.setDividerLocation(XBayaGUI.this.previousMainDividerLocation);
                    XBayaGUI.this.rightSplitPane.setDividerLocation(XBayaGUI.this.previousRightDividerLocation);
                }
            });
        }
    }

    public void addNode() {
        this.getGraphCanvas().addNode(this.componentSelector.getSelectedComponent());
    }

    public void eventReceived(Event event) {
        Event.Type type = event.getType();
        if (type == Event.Type.MONITOR_STARTED || type == Event.Type.KARMA_STARTED) {
            this.rightBottomTabbedPane.setSelectedComponent(this.monitorPane.getSwingComponent());
        }
    }

    private void init() {
        this.createFrame();
        this.menu = new XBayaMenu(this.engine, this.getToolbar());
        this.frame.setJMenuBar(this.menu.getSwingComponent());
        this.initPane();
        this.frame.setVisible(true);
        this.loadDefaultGraph();
        this.executionModeChanged(this.engine.getConfiguration());
    }

    private void initPane() {
        Container contentPane = this.frame.getContentPane();
        this.errorWindow = new ErrorWindow(contentPane);
        contentPane.add((java.awt.Component)this.getToolbar().getSwingComponent(), "First");
        this.portViewer = new PortViewer();
        this.componentViewer = new ComponentViewer();
        this.componentSelector = new ComponentSelector(this.engine);
        this.componentSelector.addComponentSelectorListener(this.componentViewer);
        this.monitorPane = new MonitorPanel(this, this.engine.getMonitor());
        this.compTreeXBayapanel = new ScrollPanel(this.componentSelector, "Component List");
        ScrollPanel compViewXBayaPanel = new ScrollPanel(this.componentViewer, "Component Information");
        this.rightBottomTabbedPane = new JTabbedPane();
        this.rightBottomTabbedPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.rightBottomTabbedPane.setPreferredSize(new Dimension(0, 200));
        this.rightBottomTabbedPane.addTab("Parameters", this.portViewer.getSwingComponent());
        this.rightBottomTabbedPane.addTab("Monitoring", this.monitorPane.getSwingComponent());
        this.graphTabbedPane = new JTabbedPane();
        this.graphTabbedPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.graphTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    XBayaGUI.this.toggleMaximizeGraphPanel();
                }
            }
        });
        this.graphTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                logger.debug(event.toString());
                XBayaGUI.this.activeTabChanged();
            }
        });
        this.leftSplitPane = new JSplitPane(0, true);
        this.rightSplitPane = new JSplitPane(0, true);
        this.mainSplitPane = new JSplitPane(1, true, this.leftSplitPane, this.rightSplitPane);
        contentPane.add((java.awt.Component)this.mainSplitPane, "Center");
        this.leftSplitPane.setOneTouchExpandable(true);
        this.rightSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.componentTabbedPane = new JTabbedPane();
        this.componentTabbedPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.leftSplitPane.setTopComponent(this.componentTabbedPane);
        this.componentTabbedPane.add(this.compTreeXBayapanel.getSwingComponent());
        this.componentTabbedPane.setTitleAt(0, "Component");
        this.leftSplitPane.setBottomComponent(compViewXBayaPanel.getSwingComponent());
        this.rightSplitPane.setTopComponent(this.graphTabbedPane);
        this.rightSplitPane.setBottomComponent(this.rightBottomTabbedPane);
        this.leftSplitPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.rightSplitPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.frame.pack();
        int leftPanelWidth = 250;
        int portViewHight = 200;
        this.mainSplitPane.setDividerLocation(250);
        this.leftSplitPane.setDividerLocation(0.5);
        this.leftSplitPane.setResizeWeight(0.5);
        this.rightSplitPane.setDividerLocation(this.rightSplitPane.getSize().height - 200);
        this.rightSplitPane.setResizeWeight(1.0);
    }

    public void viewJCRBrowserPanel() {
        if (this.jcrBrowserPanel != null) {
            JCRBrowserPanel jCRBrowserPanel = this.jcrBrowserPanel = this.componentTabbedPane.indexOfComponent(this.jcrBrowserPanel) == -1 ? null : this.jcrBrowserPanel;
        }
        if (this.jcrBrowserPanel == null) {
            this.jcrBrowserPanel = new JCRBrowserPanel(this.engine);
            this.componentTabbedPane.add(this.jcrBrowserPanel);
            int index = this.componentTabbedPane.getTabCount() - 1;
            this.componentTabbedPane.setTitleAt(1, "Airavata Registry");
            TabLabelButton tabLabelButton = new TabLabelButton(this.componentTabbedPane, "Close JCR Browser");
            tabLabelButton.setCloseButtonListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    XBayaGUI.this.componentTabbedPane.remove(XBayaGUI.this.jcrBrowserPanel);
                }
            });
            this.componentTabbedPane.setTabComponentAt(index, tabLabelButton);
        }
        this.componentTabbedPane.setSelectedComponent(this.jcrBrowserPanel);
    }

    public void viewComponentTree() {
        this.componentTabbedPane.setSelectedComponent(this.compTreeXBayapanel.getSwingComponent());
    }

    private void createFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.frame = new JFrame();
        XBayaConfiguration config = this.engine.getConfiguration();
        int width = config.getWidth();
        int height = config.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int inset = 50;
        this.frame.setLocation(50, 50);
        Dimension size = new Dimension(screenSize.width - 100, screenSize.height - 100);
        if (width != 0) {
            size.width = width;
        }
        if (height != 0) {
            size.height = height;
        }
        if (size.width > 1280 && size.height > 800) {
            size.width = 1280;
            size.height = 800;
        }
        this.frame.setPreferredSize(size);
        this.frame.setTitle("XBaya Dashboard");
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                int result = JOptionPane.showConfirmDialog(XBayaGUI.this.frame, "'Are you sure you want to exit?", "Exit XBaya", 0);
                if (result == 1 || !XBayaGUI.this.closeAllGraphCanvas()) {
                    return;
                }
                logger.debug(event.toString());
                XBayaGUI.this.frame.setVisible(false);
                try {
                    XBayaGUI.this.engine.dispose();
                }
                catch (WorkflowException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (RuntimeException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (XBayaGUI.this.engine.getConfiguration().isCloseOnExit()) {
                    System.exit(0);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                logger.debug(e.toString());
                try {
                    XBayaGUI.this.engine.getMonitor().stop();
                }
                catch (MonitorException e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
                if (XBayaGUI.this.frame.isDisplayable()) {
                    XBayaGUI.this.frame.dispose();
                }
            }
        });
        this.frame.setIconImage(SwingUtil.createImage((String)"airavata-2.png"));
    }

    private void activeTabChanged() {
        GraphCanvas graphPanel = this.getGraphCanvas();
        if (graphPanel != null) {
            Port inputPort = graphPanel.getSelectedInputPort();
            Port outputPort = graphPanel.getSelectedOutputPort();
            this.portViewer.setInputPort(inputPort);
            this.portViewer.setOutputPort(outputPort);
            Node node = graphPanel.getSelectedNode();
            Component component = node != null ? node.getComponent() : this.componentSelector.getSelectedComponent();
            this.componentViewer.setComponent(component);
            String name = graphPanel.getWorkflow().getName();
            this.setFrameName(name);
        }
    }

    public ComponentViewer getComponentVIewer() {
        return this.componentViewer;
    }

    private void setFrameName(String workflowName) {
        String title = this.engine.getConfiguration().getTitle();
        this.frame.setTitle(workflowName + " - " + title);
    }

    @Override
    public void executionModeChanged(XBayaConfiguration config) {
        this.leftSplitPane.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
    }

    public WorkflowPropertyWindow getWorkflowPropertyWindow() {
        if (this.workflowPropertiesWindow == null) {
            this.workflowPropertiesWindow = new WorkflowPropertyWindow(this);
        }
        return this.workflowPropertiesWindow;
    }

    public void setWorkflow(Workflow workflow) {
        this.getGraphCanvas().setWorkflow(workflow);
    }

    public Workflow getWorkflow() {
        return this.getGraphCanvas().getWorkflowWithImage();
    }

    private void loadDefaultGraph() {
        if (this.engine.getConfiguration().getWorkflow() != null) {
            this.newGraphCanvas(true, false);
            try {
                String xml = this.engine.getConfiguration().getAiravataAPI().getWorkflowManager().getWorkflowAsString(this.engine.getConfiguration().getWorkflow());
                XmlElement xwf = XMLUtil.stringToXmlElement((String)xml);
                Workflow workflow = new Workflow(xwf);
                this.setWorkflow(workflow);
            }
            catch (AiravataAPIInvocationException e) {
                this.getErrorWindow().error("Repository Configuration is Wrong, Failed to load the Workflow", e);
            }
            catch (GraphException e) {
                this.getErrorWindow().error("Workflow is Wrong", e);
            }
            catch (ComponentException e) {
                this.getErrorWindow().error("The component is in wrong format.", e);
            }
        }
    }

    public XBayaConfiguration getConfiguration() {
        return this.engine.getConfiguration();
    }
}

