/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.util;

import java.awt.Point;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.component.local.LocalComponentRegistry;
import org.apache.airavata.workflow.model.component.system.ConstantComponent;
import org.apache.airavata.workflow.model.component.system.DoWhileComponent;
import org.apache.airavata.workflow.model.component.system.EndDoWhileComponent;
import org.apache.airavata.workflow.model.component.system.EndForEachComponent;
import org.apache.airavata.workflow.model.component.system.EndifComponent;
import org.apache.airavata.workflow.model.component.system.ForEachComponent;
import org.apache.airavata.workflow.model.component.system.IfComponent;
import org.apache.airavata.workflow.model.component.system.InputComponent;
import org.apache.airavata.workflow.model.component.system.OutputComponent;
import org.apache.airavata.workflow.model.component.system.ReceiveComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.workflow.model.graph.system.DoWhileNode;
import org.apache.airavata.workflow.model.graph.system.IfNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.system.ReceiveNode;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.test.service.adder.Adder;
import org.apache.airavata.xbaya.test.service.approver.Approver;
import org.apache.airavata.xbaya.test.service.arrayadder.ArrayAdder;
import org.apache.airavata.xbaya.test.service.arraygen.ArrayGenerator;
import org.apache.airavata.xbaya.test.service.echo.Echo;
import org.apache.airavata.xbaya.test.service.multiplier.Multiplier;

public class WorkflowCreator {
    public static final String GFAC_TEST_AWSDL = "TestCMD_Example1_AWSDL.xml";
    private Component inputComponent;
    private Component outputComponent;
    private LocalComponentRegistry componentRegistry = new LocalComponentRegistry(XBayaPathConstants.WSDL_DIRECTORY);
    private ConstantComponent constantComponent;
    private ForEachComponent splitComponent;
    private EndForEachComponent mergeComponent;
    private IfComponent ifComponent;
    private EndifComponent endifComponent;
    private ReceiveComponent receiveComponent;
    private DoWhileComponent doWhileComponent;
    private EndDoWhileComponent endDoWhileComponent;

    public WorkflowCreator() {
        this.inputComponent = new InputComponent();
        this.outputComponent = new OutputComponent();
        this.constantComponent = new ConstantComponent();
        this.splitComponent = new ForEachComponent();
        this.mergeComponent = new EndForEachComponent();
        this.ifComponent = new IfComponent();
        this.endifComponent = new EndifComponent();
        this.receiveComponent = new ReceiveComponent();
        this.doWhileComponent = new DoWhileComponent();
        this.endDoWhileComponent = new EndDoWhileComponent();
    }

    public Workflow createSimpleMathWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Simple math workflow");
        workflow.setDescription("Simple math workflow");
        WSGraph graph = workflow.getGraph();
        WSComponent adderComp = this.componentRegistry.getComponent(Adder.WSDL_PATH);
        Node adderNode = workflow.addNode((Component)adderComp);
        adderNode.setPosition(new Point(250, 100));
        InputNode paramNode1 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode1.setPosition(new Point(50, 50));
        InputNode paramNode2 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode2.setPosition(new Point(50, 120));
        OutputNode outParamNode = (OutputNode)workflow.addNode(this.outputComponent);
        outParamNode.setPosition(new Point(300, 220));
        graph.addEdge((Port)paramNode1.getOutputPort(0), (Port)adderNode.getInputPort(0));
        graph.addEdge((Port)paramNode2.getOutputPort(0), (Port)adderNode.getInputPort(1));
        graph.addEdge(adderNode.getOutputPort(0), (Port)outParamNode.getInputPort(0));
        String paramValue1 = "2";
        paramNode1.setDefaultValue((Object)paramValue1);
        String paramValue2 = "3";
        paramNode2.setDefaultValue((Object)paramValue2);
        return workflow;
    }

    public Workflow createMathWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Math workflow");
        workflow.setDescription("A workflow that calculates (a + b) * c.");
        WSGraph graph = workflow.getGraph();
        WSComponent adderComp = this.componentRegistry.getComponent(Adder.WSDL_PATH);
        Node adderNode1 = workflow.addNode((Component)adderComp);
        adderNode1.setPosition(new Point(170, 50));
        WSComponent multiComp = this.componentRegistry.getComponent(Multiplier.WSDL_PATH);
        Node multiNode = workflow.addNode((Component)multiComp);
        multiNode.setPosition(new Point(320, 130));
        InputNode inputNode1 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode1.setPosition(new Point(20, 30));
        InputNode inputNode2 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode2.setPosition(new Point(20, 100));
        InputNode inputNode3 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode3.setPosition(new Point(20, 170));
        OutputNode outputNode = (OutputNode)workflow.addNode(this.outputComponent);
        outputNode.setPosition(new Point(500, 130));
        graph.addEdge((Port)inputNode1.getOutputPort(0), (Port)adderNode1.getInputPort(0));
        graph.addEdge((Port)inputNode2.getOutputPort(0), (Port)adderNode1.getInputPort(1));
        graph.addEdge(adderNode1.getOutputPort(0), (Port)multiNode.getInputPort(0));
        graph.addEdge((Port)inputNode3.getOutputPort(0), (Port)multiNode.getInputPort(1));
        graph.addEdge(multiNode.getOutputPort(0), (Port)outputNode.getInputPort(0));
        inputNode1.setConfiguredName("a");
        inputNode2.setConfiguredName("b");
        inputNode3.setConfiguredName("c");
        inputNode1.setConfigured(true);
        inputNode2.setConfigured(true);
        inputNode3.setConfigured(true);
        inputNode1.setDefaultValue((Object)"2");
        inputNode2.setDefaultValue((Object)"3");
        inputNode3.setDefaultValue((Object)"4");
        outputNode.setConfiguredName("z");
        outputNode.setConfigured(true);
        return workflow;
    }

    public Workflow createComplexMathWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Complex math workflow");
        workflow.setDescription("Complex math workflow");
        WSGraph graph = workflow.getGraph();
        WSComponent adderComp = this.componentRegistry.getComponent(Adder.WSDL_PATH);
        Node adderNode1 = workflow.addNode((Component)adderComp);
        adderNode1.setPosition(new Point(170, 50));
        Node adderNode2 = workflow.addNode((Component)adderComp);
        adderNode2.setPosition(new Point(170, 210));
        WSComponent multiComp = this.componentRegistry.getComponent(Multiplier.WSDL_PATH);
        Node multiNode = workflow.addNode((Component)multiComp);
        multiNode.setPosition(new Point(320, 130));
        InputNode inputNode1 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode1.setPosition(new Point(20, 30));
        InputNode inputNode2 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode2.setPosition(new Point(20, 100));
        InputNode inputNode3 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode3.setPosition(new Point(20, 170));
        InputNode inputNode4 = (InputNode)workflow.addNode(this.inputComponent);
        inputNode4.setPosition(new Point(20, 240));
        OutputNode outputNode = (OutputNode)workflow.addNode(this.outputComponent);
        outputNode.setPosition(new Point(500, 130));
        graph.addEdge((Port)inputNode1.getOutputPort(0), (Port)adderNode1.getInputPort(0));
        graph.addEdge((Port)inputNode2.getOutputPort(0), (Port)adderNode1.getInputPort(1));
        graph.addEdge((Port)inputNode3.getOutputPort(0), (Port)adderNode2.getInputPort(0));
        graph.addEdge((Port)inputNode4.getOutputPort(0), (Port)adderNode2.getInputPort(1));
        graph.addEdge(adderNode1.getOutputPort(0), (Port)multiNode.getInputPort(0));
        graph.addEdge(adderNode2.getOutputPort(0), (Port)multiNode.getInputPort(1));
        graph.addEdge(multiNode.getOutputPort(0), (Port)outputNode.getInputPort(0));
        inputNode1.setConfiguredName("a");
        inputNode2.setConfiguredName("b");
        inputNode3.setConfiguredName("c");
        inputNode4.setConfiguredName("d");
        inputNode1.setDescription("This is the first input.");
        inputNode2.setDescription("This is the second input.");
        inputNode3.setDescription("This is the third input.");
        inputNode4.setDescription("This is the fourth input.");
        inputNode1.setConfigured(true);
        inputNode2.setConfigured(true);
        inputNode3.setConfigured(true);
        inputNode4.setConfigured(true);
        inputNode1.setDefaultValue((Object)"2");
        inputNode2.setDefaultValue((Object)"3");
        inputNode3.setDefaultValue((Object)"4");
        inputNode4.setDefaultValue((Object)"5");
        outputNode.setConfiguredName("z");
        outputNode.setConfigured(true);
        return workflow;
    }

    public Workflow createMathWithConstWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Math with const");
        workflow.setDescription("Math with const");
        WSGraph graph = workflow.getGraph();
        WSComponent adderComp = this.componentRegistry.getComponent(Adder.WSDL_PATH);
        Node adderNode = workflow.addNode((Component)adderComp);
        adderNode.setPosition(new Point(250, 100));
        InputNode inputNode = (InputNode)workflow.addNode(this.inputComponent);
        inputNode.setPosition(new Point(50, 50));
        ConstantNode constantNode = (ConstantNode)workflow.addNode((Component)this.constantComponent);
        constantNode.setPosition(new Point(50, 120));
        OutputNode outParamNode = (OutputNode)workflow.addNode(this.outputComponent);
        outParamNode.setPosition(new Point(300, 220));
        graph.addEdge((Port)inputNode.getOutputPort(0), (Port)adderNode.getInputPort(0));
        graph.addEdge((Port)constantNode.getOutputPort(0), (Port)adderNode.getInputPort(1));
        graph.addEdge(adderNode.getOutputPort(0), (Port)outParamNode.getInputPort(0));
        String paramValue1 = "2";
        inputNode.setDefaultValue((Object)paramValue1);
        String paramValue2 = "3";
        constantNode.setValue((Object)paramValue2);
        return workflow;
    }

    public Workflow createArrayWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Array test");
        workflow.setDescription("A workflow that tests arrays");
        WSGraph graph = workflow.getGraph();
        InputNode inputN = (InputNode)workflow.addNode(this.inputComponent);
        inputN.setPosition(new Point(0, 80));
        WSComponent arrayGeneratorComponent = this.componentRegistry.getComponent(ArrayGenerator.WSDL_PATH);
        Node arrayGenerator = workflow.addNode((Component)arrayGeneratorComponent);
        arrayGenerator.setPosition(new Point(150, 80));
        WSComponent arrayAdderComponent = this.componentRegistry.getComponent(ArrayAdder.WSDL_PATH);
        Node arrayAdder = workflow.addNode((Component)arrayAdderComponent);
        arrayAdder.setPosition(new Point(400, 80));
        OutputNode output = (OutputNode)workflow.addNode(this.outputComponent);
        output.setConfiguredName("output");
        output.setPosition(new Point(550, 80));
        graph.addEdge((Port)inputN.getOutputPort(0), (Port)arrayGenerator.getInputPort(0));
        graph.addEdge(arrayGenerator.getOutputPort(0), (Port)arrayAdder.getInputPort(0));
        graph.addEdge(arrayAdder.getOutputPort(0), (Port)output.getInputPort(0));
        String n = "5";
        inputN.setDefaultValue((Object)n);
        return workflow;
    }

    public Workflow createForEachWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("ForEach test");
        workflow.setDescription("Workflow that tests if");
        WSGraph graph = workflow.getGraph();
        InputNode inputX = (InputNode)workflow.addNode(this.inputComponent);
        inputX.setPosition(new Point(0, 0));
        InputNode inputN = (InputNode)workflow.addNode(this.inputComponent);
        inputN.setPosition(new Point(0, 80));
        WSComponent arrayGeneratorComponent = this.componentRegistry.getComponent(ArrayGenerator.WSDL_PATH);
        Node arrayGenerator = workflow.addNode((Component)arrayGeneratorComponent);
        arrayGenerator.setPosition(new Point(120, 80));
        Node split = workflow.addNode((Component)this.splitComponent);
        split.setPosition(new Point(310, 80));
        WSComponent adderComponent = this.componentRegistry.getComponent(Adder.WSDL_PATH);
        Node adder = workflow.addNode((Component)adderComponent);
        adder.setPosition(new Point(440, 40));
        Node merge = workflow.addNode((Component)this.mergeComponent);
        merge.setPosition(new Point(580, 40));
        OutputNode output = (OutputNode)workflow.addNode(this.outputComponent);
        output.setConfiguredName("output");
        output.setPosition(new Point(720, 40));
        graph.addEdge((Port)inputX.getOutputPort(0), (Port)adder.getInputPort(0));
        graph.addEdge((Port)inputN.getOutputPort(0), (Port)arrayGenerator.getInputPort(0));
        graph.addEdge(arrayGenerator.getOutputPort(0), (Port)split.getInputPort(0));
        graph.addEdge(split.getOutputPort(0), (Port)adder.getInputPort(1));
        graph.addEdge(adder.getOutputPort(0), (Port)merge.getInputPort(0));
        graph.addEdge(merge.getOutputPort(0), (Port)output.getInputPort(0));
        String x = "2";
        inputX.setDefaultValue((Object)x);
        String n = "3";
        inputN.setDefaultValue((Object)n);
        return workflow;
    }

    public Workflow createIfWorkflow() throws GraphException, ComponentException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("If test");
        workflow.setDescription("Workflow that tests if");
        WSGraph graph = workflow.getGraph();
        InputNode x = (InputNode)workflow.addNode(this.inputComponent);
        x.setPosition(new Point(10, 10));
        InputNode y = (InputNode)workflow.addNode(this.inputComponent);
        y.setPosition(new Point(10, 90));
        ConstantNode const0 = (ConstantNode)workflow.addNode((Component)this.constantComponent);
        const0.setPosition(new Point(20, 180));
        IfNode ifNode = (IfNode)workflow.addNode((Component)this.ifComponent);
        ifNode.setPosition(new Point(170, 180));
        WSComponent adderComp = this.componentRegistry.getComponent(Adder.WSDL_PATH);
        Node adder = workflow.addNode((Component)adderComp);
        adder.setPosition(new Point(400, 10));
        WSComponent multiComp = this.componentRegistry.getComponent(Multiplier.WSDL_PATH);
        Node multiplier = workflow.addNode((Component)multiComp);
        multiplier.setPosition(new Point(400, 90));
        Node endif = workflow.addNode((Component)this.endifComponent);
        endif.setPosition(new Point(550, 40));
        OutputNode output = (OutputNode)workflow.addNode(this.outputComponent);
        output.setConfiguredName("output");
        output.setPosition(new Point(700, 40));
        graph.addEdge((Port)x.getOutputPort(0), (Port)adder.getInputPort(0));
        graph.addEdge((Port)x.getOutputPort(0), (Port)multiplier.getInputPort(0));
        graph.addEdge((Port)y.getOutputPort(0), (Port)adder.getInputPort(1));
        graph.addEdge((Port)y.getOutputPort(0), (Port)multiplier.getInputPort(1));
        graph.addEdge((Port)const0.getOutputPort(0), (Port)ifNode.getInputPort(0));
        graph.addEdge((Port)ifNode.getControlOutPorts().get(0), (Port)adder.getControlInPort());
        graph.addEdge((Port)ifNode.getControlOutPorts().get(1), (Port)multiplier.getControlInPort());
        graph.addEdge(adder.getOutputPort(0), (Port)endif.getInputPort(0));
        graph.addEdge(multiplier.getOutputPort(0), (Port)endif.getInputPort(1));
        graph.addEdge(endif.getOutputPort(0), (Port)output.getInputPort(0));
        x.setDefaultValue((Object)"2");
        y.setDefaultValue((Object)"3");
        const0.setValue((Object)"adder");
        ifNode.setXPath("$0 = 'adder'");
        return workflow;
    }

    public Workflow createReceiveWorkflow() throws GraphException, ComponentException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Receive test");
        workflow.setDescription("Workflow that tests receive");
        WSGraph graph = workflow.getGraph();
        WSComponent echoComponent = this.componentRegistry.getComponent(Echo.WSDL_PATH);
        Node echo = workflow.addNode((Component)echoComponent);
        echo.setPosition(new Point(40, 40));
        ReceiveNode receive = (ReceiveNode)workflow.addNode((Component)this.receiveComponent);
        receive.setPosition(new Point(200, 200));
        OutputNode output1 = (OutputNode)workflow.addNode(this.outputComponent);
        output1.setPosition(new Point(350, 40));
        OutputNode output2 = (OutputNode)workflow.addNode(this.outputComponent);
        output2.setPosition(new Point(350, 200));
        graph.addEdge((Port)receive.getEPRPort(), (Port)echo.getInputPort(0));
        graph.addEdge(echo.getOutputPort(0), (Port)output1.getInputPort(0));
        graph.addEdge((Port)receive.getOutputPort(0), (Port)output2.getInputPort(0));
        graph.addEdge((Port)echo.getControlOutPorts().get(0), (Port)receive.getControlInPort());
        output1.setConfiguredName("output1");
        output1.setConfigured(true);
        output2.setConfiguredName("output2");
        output2.setConfigured(true);
        return workflow;
    }

    public Workflow createGFacWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("GFac test workflow");
        workflow.setDescription("GFac test workflow");
        WSGraph graph = workflow.getGraph();
        WSComponent gfacComp = this.componentRegistry.getComponent(GFAC_TEST_AWSDL);
        Node gfacNode = workflow.addNode((Component)gfacComp);
        gfacNode.setPosition(new Point(250, 100));
        InputNode paramNode1 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode1.setPosition(new Point(50, 50));
        String paramValue1 = "300";
        paramNode1.setDefaultValue((Object)paramValue1);
        OutputNode outParamNode = (OutputNode)workflow.addNode(this.outputComponent);
        outParamNode.setPosition(new Point(300, 220));
        graph.addEdge((Port)paramNode1.getOutputPort(0), (Port)gfacNode.getInputPort(0));
        graph.addEdge(gfacNode.getOutputPort(0), (Port)outParamNode.getInputPort(0));
        return workflow;
    }

    public Workflow createLoanWorkflow() throws GraphException, ComponentException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Loan Approval");
        workflow.setDescription("Loan Approval");
        WSGraph graph = workflow.getGraph();
        InputNode amount = (InputNode)workflow.addNode(this.inputComponent);
        amount.setPosition(new Point(10, 10));
        IfNode ifNode = (IfNode)workflow.addNode((Component)this.ifComponent);
        ifNode.setPosition(new Point(200, 100));
        WSComponent approverComponent = this.componentRegistry.getComponent(Approver.WSDL_PATH);
        Node approver = workflow.addNode((Component)approverComponent);
        approver.setPosition(new Point(350, 10));
        ConstantNode constYes = (ConstantNode)workflow.addNode((Component)this.constantComponent);
        constYes.setPosition(new Point(350, 200));
        Node endif = workflow.addNode((Component)this.endifComponent);
        endif.setPosition(new Point(550, 100));
        OutputNode output = (OutputNode)workflow.addNode(this.outputComponent);
        output.setPosition(new Point(700, 100));
        graph.addEdge((Port)amount.getOutputPort(0), (Port)approver.getInputPort(0));
        graph.addEdge((Port)amount.getOutputPort(0), (Port)ifNode.getInputPort(0));
        graph.addEdge((Port)ifNode.getControlOutPorts().get(0), (Port)approver.getControlInPort());
        graph.addEdge((Port)ifNode.getControlOutPorts().get(1), (Port)constYes.getControlInPort());
        graph.addEdge(approver.getOutputPort(0), (Port)endif.getInputPort(0));
        graph.addEdge((Port)constYes.getOutputPort(0), (Port)endif.getInputPort(1));
        graph.addEdge(endif.getOutputPort(0), (Port)output.getInputPort(0));
        amount.setDefaultValue((Object)"500");
        constYes.setValue((Object)"Yes");
        ifNode.setXPath("$0 > 1000");
        output.setConfiguredName("accept");
        output.setConfigured(true);
        return workflow;
    }

    public Workflow createDoWhileWorkflow() throws GraphException, ComponentException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("Do While");
        workflow.setDescription("Do While");
        WSGraph graph = workflow.getGraph();
        InputNode amount = (InputNode)workflow.addNode(this.inputComponent);
        amount.setPosition(new Point(10, 10));
        DoWhileNode doWhileNode = (DoWhileNode)workflow.addNode((Component)this.doWhileComponent);
        doWhileNode.setPosition(new Point(200, 100));
        WSComponent approverComponent = this.componentRegistry.getComponent(Approver.WSDL_PATH);
        Node approver = workflow.addNode((Component)approverComponent);
        approver.setPosition(new Point(350, 10));
        ConstantNode constYes = (ConstantNode)workflow.addNode((Component)this.constantComponent);
        constYes.setPosition(new Point(350, 200));
        Node endDoWhile = workflow.addNode((Component)this.endDoWhileComponent);
        endDoWhile.setPosition(new Point(550, 100));
        OutputNode output = (OutputNode)workflow.addNode(this.outputComponent);
        output.setPosition(new Point(700, 100));
        graph.addEdge((Port)amount.getOutputPort(0), (Port)approver.getInputPort(0));
        graph.addEdge((Port)amount.getOutputPort(0), (Port)doWhileNode.getInputPort(0));
        graph.addEdge((Port)doWhileNode.getControlOutPorts().get(0), (Port)approver.getControlInPort());
        graph.addEdge((Port)doWhileNode.getControlOutPorts().get(1), (Port)constYes.getControlInPort());
        graph.addEdge(approver.getOutputPort(0), (Port)endDoWhile.getInputPort(0));
        graph.addEdge((Port)constYes.getOutputPort(0), (Port)endDoWhile.getInputPort(1));
        graph.addEdge(endDoWhile.getOutputPort(0), (Port)output.getInputPort(0));
        amount.setDefaultValue((Object)"0");
        constYes.setValue((Object)"Yes");
        doWhileNode.setXpath("$1 = 1");
        output.setConfiguredName("accept");
        output.setConfigured(true);
        return workflow;
    }
}

