/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.multiplier;

import java.util.Random;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.ServiceNotificationSender;
import org.apache.airavata.xbaya.test.service.multiplier.Multiplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import xsul.XmlConstants;

public class MultiplierImpl
implements Multiplier {
    private static final Logger logger = LoggerFactory.getLogger(MultiplierImpl.class);

    @Override
    public XmlElement multiply(XmlElement inputElement) {
        logger.info(XMLUtil.xmlElementToString((XmlElement)inputElement));
        ServiceNotificationSender notifier = ServiceNotificationSender.invoked(inputElement);
        XmlElement xElement = inputElement.requiredElement(null, "x");
        XmlElement yElement = inputElement.requiredElement(null, "y");
        String xString = xElement.requiredTextContent();
        String yString = yElement.requiredTextContent();
        int x = Integer.parseInt(xString);
        int y = Integer.parseInt(yString);
        Random random = new Random();
        int msec = random.nextInt(10000);
        logger.info("Sleep for " + msec + " msec");
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        int z = x * y;
        String zString = "" + z;
        XmlNamespace namespace = XmlConstants.BUILDER.newNamespace("multipliertypens", "http://www.extreme.indiana.edu/math/multiplier/xsd/");
        XmlElement outputElement = XmlConstants.BUILDER.newFragment(namespace, "MultiplyOutput");
        XmlElement zElement = outputElement.addElement("z");
        zElement.addChild((Object)zString);
        if (notifier != null) {
            notifier.sendingResult(outputElement);
        }
        logger.info(XMLUtil.xmlElementToString((XmlElement)outputElement));
        return outputElement;
    }
}

