/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.echo;

import java.io.File;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.Service;
import org.apache.airavata.xbaya.test.service.echo.Echo;
import org.apache.airavata.xbaya.test.service.echo.EchoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.wsdl.WsdlDefinitions;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xservo.XService;
import xsul.xservo_soap.XSoapDocLiteralService;
import xsul.xservo_soap_http.HttpBasedServices;

public class EchoService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(EchoService.class);
    private HttpBasedServices httpServices;
    private XService xservice;
    private int port;

    public EchoService(int port) {
        this.port = port;
    }

    public void run() {
        this.httpServices = new HttpBasedServices(this.port);
        this.xservice = this.httpServices.addService((XService)new XSoapDocLiteralService("EchoService", "math" + File.separator + Echo.WSDL_PATH, (Object)new EchoImpl()));
        this.xservice.addHandler((XHandler)new StickySoapHeaderHandler("retrieve-lead-header", LeadContextHeader.TYPE));
        this.xservice.startService();
    }

    public String getServiceWsdlLocation() {
        return this.httpServices.getServer().getLocation() + "/" + "EchoService" + "?wsdl";
    }

    public WsdlDefinitions getWsdl() {
        return this.xservice.getWsdl();
    }

    public void shutdownServer() {
        this.httpServices.getServer().shutdownServer();
    }

    public static void main(String[] args) {
        try {
            int port = 0;
            if (args.length == 2 && "-port".equalsIgnoreCase(args[0])) {
                port = Integer.parseInt(args[1]);
            }
            EchoService service = new EchoService(port);
            service.run();
            WsdlDefinitions wsdl = service.getWsdl();
            File wsdlFile = new File(SAMPLE_WSDL_DIRECTORY, "echo.wsdl");
            XMLUtil.saveXML((XmlElement)wsdl, (File)wsdlFile);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

