/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.echo;

import java.util.Random;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.ServiceNotificationSender;
import org.apache.airavata.xbaya.test.service.echo.Echo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import xsul.XmlConstants;

public class EchoImpl
implements Echo {
    private static final Logger logger = LoggerFactory.getLogger(EchoImpl.class);

    @Override
    public XmlElement echo(XmlElement inputElement) {
        logger.info(XMLUtil.xmlElementToString((XmlElement)inputElement));
        ServiceNotificationSender notifier = ServiceNotificationSender.invoked(inputElement);
        XmlElement input = inputElement.requiredElement(null, "input");
        Random random = new Random();
        int msec = random.nextInt(5000);
        logger.info("Sleep for " + msec + " msec");
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        XmlElement output = input;
        output.setParent(null);
        output.setName("output");
        XmlNamespace namespace = XmlConstants.BUILDER.newNamespace("echotypens", "http://www.extreme.indiana.edu/math/echo/xsd/");
        XmlElement outputElement = XmlConstants.BUILDER.newFragment(namespace, "EchoOutput");
        outputElement.addElement(output);
        if (notifier != null) {
            notifier.sendingResult(outputElement);
        }
        logger.info(XMLUtil.xmlElementToString((XmlElement)outputElement));
        return outputElement;
    }
}

