/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.arraygen;

import java.util.Random;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.ServiceNotificationSender;
import org.apache.airavata.xbaya.test.service.arraygen.ArrayGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import xsul.XmlConstants;

public class ArrayGeneratorImpl
implements ArrayGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ArrayGeneratorImpl.class);

    @Override
    public XmlElement generate(XmlElement inputElement) {
        logger.info(XMLUtil.xmlElementToString((XmlElement)inputElement));
        ServiceNotificationSender notifier = ServiceNotificationSender.invoked(inputElement);
        XmlElement nElement = inputElement.requiredElement(null, "n");
        String nString = nElement.requiredTextContent();
        int n = Integer.parseInt(nString);
        Random random = new Random();
        int msec = random.nextInt(5000);
        logger.info("Sleep for " + msec + " msec");
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        XmlNamespace namespace = XmlConstants.BUILDER.newNamespace("typens", "http://www.extreme.indiana.edu/math/arraygen/xsd/");
        XmlElement outputElement = XmlConstants.BUILDER.newFragment(namespace, "ArrayGeneratorOutput");
        XmlElement arrayElement = outputElement.addElement("output");
        for (int i = 0; i < n; ++i) {
            XmlElement valueElement = arrayElement.addElement("value");
            valueElement.addChild((Object)("" + i));
        }
        if (notifier != null) {
            notifier.sendingResult(outputElement);
        }
        logger.info(XMLUtil.xmlElementToString((XmlElement)outputElement));
        return outputElement;
    }
}

