/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.arrayadder;

import java.util.Random;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.ServiceNotificationSender;
import org.apache.airavata.xbaya.test.service.arrayadder.ArrayAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import xsul.XmlConstants;

public class ArrayAdderImpl
implements ArrayAdder {
    private static final Logger logger = LoggerFactory.getLogger(ArrayAdderImpl.class);

    @Override
    public XmlElement add(XmlElement inputElement) {
        logger.info(XMLUtil.xmlElementToString((XmlElement)inputElement));
        ServiceNotificationSender notifier = ServiceNotificationSender.invoked(inputElement);
        XmlElement arrayElement = inputElement.requiredElement(null, "input");
        int sum = 0;
        for (XmlElement valueElement : arrayElement.elements(null, "value")) {
            String valueString = valueElement.requiredTextContent();
            int value = Integer.parseInt(valueString);
            sum += value;
        }
        Random random = new Random();
        int msec = random.nextInt(5000);
        logger.info("Sleep for " + msec + " msec");
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String sumString = "" + sum;
        XmlNamespace namespace = XmlConstants.BUILDER.newNamespace("typens", "http://www.extreme.indiana.edu/math/arrayadder/xsd/");
        XmlElement outputElement = XmlConstants.BUILDER.newFragment(namespace, "ArrayAdderOutput");
        XmlElement sumElement = outputElement.addElement("sum");
        sumElement.addChild((Object)sumString);
        if (notifier != null) {
            notifier.sendingResult(outputElement);
        }
        logger.info(XMLUtil.xmlElementToString((XmlElement)outputElement));
        return outputElement;
    }
}

