/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.approver;

import java.io.File;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.approver.ApproverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.wsdl.WsdlDefinitions;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xservo.XService;
import xsul.xservo_soap.XSoapDocLiteralService;
import xsul.xservo_soap_http.HttpBasedServices;

public class ApproverService {
    private static final String SERVICE_NAME = "ApproverService";
    private static final String BASE_WSDL_LOCATION = "wsdls/loan/approver-wsdl.xml";
    private static final String OUTPUT_WSDL_LOCATION = "wsdls/sample/approver-wsdl.xml";
    private static final Logger logger = LoggerFactory.getLogger(ApproverService.class);
    private HttpBasedServices httpServices;
    private XService xservice;
    private int port;

    public ApproverService() {
        this(0);
    }

    public ApproverService(int port) {
        this.port = port;
    }

    public void run() {
        this.httpServices = new HttpBasedServices(this.port);
        logger.info("Server started on " + this.httpServices.getServerPort());
        logger.info("Using WSDL for service description from wsdls/loan/approver-wsdl.xml");
        this.xservice = this.httpServices.addService((XService)new XSoapDocLiteralService(SERVICE_NAME, BASE_WSDL_LOCATION, (Object)new ApproverImpl()));
        this.xservice.addHandler((XHandler)new StickySoapHeaderHandler("retrieve-lead-header", LeadContextHeader.TYPE));
        this.xservice.startService();
        logger.info("Service started");
        logger.info("Service WSDL available at " + this.getServiceWsdlLocation());
    }

    public String getServiceWsdlLocation() {
        return this.httpServices.getServer().getLocation() + "/" + SERVICE_NAME + "?wsdl";
    }

    public WsdlDefinitions getWsdl() {
        return this.xservice.getWsdl();
    }

    public void shutdownServer() {
        this.httpServices.getServer().shutdownServer();
    }

    public static void main(String[] args) {
        try {
            int port = 0;
            if (args.length == 2 && "-port".equalsIgnoreCase(args[0])) {
                port = Integer.parseInt(args[1]);
            }
            ApproverService service = new ApproverService(port);
            service.run();
            WsdlDefinitions wsdl = service.getWsdl();
            File wsdlFile = new File(OUTPUT_WSDL_LOCATION);
            XMLUtil.saveXML((XmlElement)wsdl, (File)wsdlFile);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

