/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.approver;

import java.util.Random;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.test.service.ServiceNotificationSender;
import org.apache.airavata.xbaya.test.service.approver.Approver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import xsul.XmlConstants;

public class ApproverImpl
implements Approver {
    private static final Logger logger = LoggerFactory.getLogger(ApproverImpl.class);

    @Override
    public XmlElement approve(XmlElement inputElement) {
        logger.info(XMLUtil.xmlElementToString((XmlElement)inputElement));
        ServiceNotificationSender notifier = ServiceNotificationSender.invoked(inputElement);
        XmlElement amountElement = inputElement.requiredElement(null, "amount");
        String amountString = amountElement.requiredTextContent();
        int amount = Integer.parseInt(amountString);
        logger.info("amount: " + amount);
        Random random = new Random();
        int msec = random.nextInt(5000);
        logger.info("Sleep for " + msec + " msec");
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String accept = "No";
        XmlNamespace namespace = XmlConstants.BUILDER.newNamespace("approvertypens", "http://www.extreme.indiana.edu/loan/approver/xsd/");
        XmlElement outputElement = XmlConstants.BUILDER.newFragment(namespace, "ApproveOutput");
        XmlElement acceptElement = outputElement.addElement("accept");
        acceptElement.addChild((Object)accept);
        if (notifier != null) {
            notifier.sendingResult(outputElement);
        }
        logger.info(XMLUtil.xmlElementToString((XmlElement)outputElement));
        return outputElement;
    }
}

