/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service.adder;

import java.net.URI;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.lead.LeadContextHeaderHelper;
import org.apache.airavata.xbaya.test.service.adder.AdderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;
import xsul.xwsif_runtime_async.WSIFAsyncResponsesCorrelator;

public class AdderClient {
    private static final Logger logger = LoggerFactory.getLogger(AdderClient.class);
    private AdderService service;

    public void run() {
        String wsdlLoc = this.startServer();
        this.runClient(wsdlLoc);
        this.shutdownServer();
    }

    private String startServer() {
        this.service = new AdderService();
        this.service.run();
        return this.service.getServiceWsdlLocation();
    }

    private void shutdownServer() {
        this.service.shutdownServer();
    }

    private void runClient(String wsdlLoc) {
        logger.info("Invoking operation echoString using WSDL from " + wsdlLoc);
        WSIFAsyncResponsesCorrelator correlator = null;
        LeadContextHeaderHelper helper = new LeadContextHeaderHelper();
        helper.setXBayaConfiguration(new XBayaConfiguration());
        LeadContextHeader leadContext = helper.getLeadContextHeader();
        leadContext.setWorkflowId(URI.create("http://host/2005/11/09/workflowinstace"));
        leadContext.setNodeId("decoder1");
        leadContext.setTimeStep("5");
        leadContext.setServiceId("decoder-instance-10");
        WSIFClient wclient = WSIFRuntime.newClient((String)wsdlLoc).addHandler((XHandler)new StickySoapHeaderHandler("use-lead-header", (XmlElement)leadContext)).useAsyncMessaging(correlator).setAsyncResponseTimeoutInMs(33000L);
        WSIFPort port = wclient.getPort();
        WSIFOperation operation = port.createOperation("add");
        WSIFMessage inputMessage = operation.createInputMessage();
        WSIFMessage outputMessage = operation.createOutputMessage();
        WSIFMessage faultMessage = operation.createFaultMessage();
        inputMessage.setObjectPart("x", (Object)"2");
        inputMessage.setObjectPart("y", (Object)"3");
        logger.info("Sending a message:\n" + XMLUtil.xmlElementToString((XmlElement)((XmlElement)inputMessage)));
        boolean success = operation.executeRequestResponseOperation(inputMessage, outputMessage, faultMessage);
        XmlElement result = success ? (XmlElement)outputMessage : (XmlElement)faultMessage;
        logger.info("Received message:\n" + XMLUtil.xmlElementToString((XmlElement)result));
    }

    public static void main(String[] args) {
        new AdderClient().run();
    }
}

