/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service;

import java.net.URI;
import java.util.Properties;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.tracking.Notifier;
import org.apache.airavata.workflow.tracking.NotifierFactory;
import org.apache.airavata.workflow.tracking.common.InvocationContext;
import org.apache.airavata.workflow.tracking.common.InvocationEntity;
import org.apache.airavata.workflow.tracking.common.WorkflowTrackingContext;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.soap.SoapUtil;
import xsul.soap11_util.Soap11Util;
import xsul.soap12_util.Soap12Util;
import xsul.xbeans_util.XBeansUtil;

public class ServiceNotificationSender {
    private static final Logger logger = LoggerFactory.getLogger(ServiceNotificationSender.class);
    private static final String INVOKED_MESSAGE = "Service is invoked";
    private static final String SENDING_RESULT_MESSAGE = "Sending successful result of invocation";
    private Notifier notifier;
    private InvocationEntity initiator;
    private InvocationEntity receiver;
    private InvocationContext invocationContext;
    private WorkflowTrackingContext context;
    private SoapUtil soapFragrance;

    public static ServiceNotificationSender invoked(XmlElement inputElement) {
        try {
            XmlElement soapBody = (XmlElement)inputElement.getParent();
            XmlElement soapEnvelope = (XmlElement)soapBody.getParent();
            SoapUtil soapFragrance = SoapUtil.selectSoapFragrance((XmlElement)soapEnvelope, (SoapUtil[])new SoapUtil[]{Soap11Util.getInstance(), Soap12Util.getInstance()});
            XmlElement soapHeader = soapEnvelope.element(null, "Header");
            XmlElement leadHeader = soapHeader.element(LeadContextHeader.NS, LeadContextHeader.TYPE.getLocalPart());
            logger.info("leadHeader: " + XMLUtil.xmlElementToString((XmlElement)leadHeader));
            if (leadHeader == null) {
                return null;
            }
            LeadContextHeader leadContext = new LeadContextHeader(leadHeader);
            ServiceNotificationSender sender = new ServiceNotificationSender(soapFragrance, leadContext);
            sender.serviceInvoked(inputElement);
            return sender;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ServiceNotificationSender(SoapUtil soapFragrance, LeadContextHeader leadContext) {
        this.soapFragrance = soapFragrance;
        this.notifier = NotifierFactory.createNotifier();
        URI workflowID = leadContext.getWorkflowId();
        String serviceIDString = leadContext.getServiceId();
        if (serviceIDString == null) {
            serviceIDString = "serviceIDWasNull";
        }
        URI serviceID = URI.create(serviceIDString);
        String nodeID = leadContext.getNodeId();
        String timeStepString = leadContext.getTimeStep();
        Integer timeStep = null;
        if (timeStepString != null) {
            try {
                timeStep = new Integer(timeStepString);
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.initiator = this.notifier.createEntity(workflowID, serviceID, nodeID, timeStep);
        this.receiver = this.notifier.createEntity(workflowID, serviceID, nodeID, timeStep);
        EndpointReference epr = new EndpointReference(leadContext.getEventSink().getAddress().toString());
        this.context = this.notifier.createTrackingContext(new Properties(), epr.toString(), workflowID, serviceID, nodeID, timeStep);
    }

    private void serviceInvoked(XmlElement inputElement) {
        XmlElement soapBody = (XmlElement)inputElement.getParent();
        XmlElement soapEnvelope = (XmlElement)soapBody.getParent();
        XmlElement soapHeader = soapEnvelope.element(null, "Header");
        XmlObject headerObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapHeader);
        XmlObject bodyObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapBody);
        this.invocationContext = this.notifier.serviceInvoked(this.context, this.initiator, headerObject, bodyObject, new String[]{INVOKED_MESSAGE});
    }

    public void sendingResult(XmlElement outputElement) {
        try {
            XmlDocument document = this.soapFragrance.wrapBodyContent(outputElement);
            XmlElement soapEnvelope = document.getDocumentElement();
            XmlElement soapHeader = soapEnvelope.element(null, "Header");
            XmlElement soapBody = soapEnvelope.element(null, "Body");
            XmlObject headerObject = null;
            if (soapHeader != null) {
                headerObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapHeader);
            }
            XmlObject bodyObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapBody);
            this.notifier.sendingResult(this.context, this.invocationContext, headerObject, bodyObject, new String[]{SENDING_RESULT_MESSAGE});
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

