/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.service;

import java.io.File;
import java.io.IOException;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.test.service.Service;
import org.apache.airavata.xbaya.test.service.adder.Adder;
import org.apache.airavata.xbaya.test.service.adder.AdderImpl;
import org.apache.airavata.xbaya.test.service.approver.Approver;
import org.apache.airavata.xbaya.test.service.approver.ApproverImpl;
import org.apache.airavata.xbaya.test.service.arrayadder.ArrayAdder;
import org.apache.airavata.xbaya.test.service.arrayadder.ArrayAdderImpl;
import org.apache.airavata.xbaya.test.service.arraygen.ArrayGenerator;
import org.apache.airavata.xbaya.test.service.arraygen.ArrayGeneratorImpl;
import org.apache.airavata.xbaya.test.service.echo.Echo;
import org.apache.airavata.xbaya.test.service.echo.EchoImpl;
import org.apache.airavata.xbaya.test.service.multiplier.Multiplier;
import org.apache.airavata.xbaya.test.service.multiplier.MultiplierImpl;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.wsdl.WsdlDefinitions;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xservo.XService;
import xsul.xservo_soap.XSoapDocLiteralService;
import xsul.xservo_soap_http.HttpBasedServices;

public class AllServices {
    private int port;
    private HttpBasedServices httpServices;

    public AllServices(int port) {
        this.port = port;
    }

    public void startAll() throws IOException {
        this.httpServices = new HttpBasedServices(this.port);
        this.start("AdderService", "adder.wsdl", Adder.WSDL_PATH, new AdderImpl());
        this.start("MultiplierService", "multiplier.wsdl", Multiplier.WSDL_PATH, new MultiplierImpl());
        this.start("ArrayGeneratorService", "arraygen.wsdl", ArrayGenerator.WSDL_PATH, new ArrayGeneratorImpl());
        this.start("ArrayAdderService", "arrayadder.wsdl", ArrayAdder.WSDL_PATH, new ArrayAdderImpl());
        this.start("EchoService", "echo.wsdl", Echo.WSDL_PATH, new EchoImpl());
        this.start("ApproverService", "approver.wsdl", Approver.WSDL_PATH, new ApproverImpl());
    }

    private void start(String serviceName, String wsdlName, String wsdlPath, Object serviceImpl) throws IOException {
        String wsdlLocation = XBayaPathConstants.WSDL_DIRECTORY + File.separator + wsdlPath;
        XService xservice = this.httpServices.addService((XService)new XSoapDocLiteralService(serviceName, wsdlLocation, serviceImpl));
        xservice.addHandler((XHandler)new StickySoapHeaderHandler("retrieve-lead-header", LeadContextHeader.TYPE));
        xservice.startService();
        WsdlDefinitions wsdl = xservice.getWsdl();
        File wsdlFile = new File(Service.SAMPLE_WSDL_DIRECTORY, wsdlName);
        XMLUtil.saveXML((XmlElement)wsdl, (File)wsdlFile);
    }

    public static void main(String[] args) throws IOException {
        int port = 0;
        if (args.length == 2 && "-port".equalsIgnoreCase(args[0])) {
            port = Integer.parseInt(args[1]);
        }
        AllServices service = new AllServices(port);
        service.startAll();
    }
}

