/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.jython;

import java.io.IOException;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.jython.runner.JythonRunner;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.service.adder.AdderService;
import org.apache.airavata.xbaya.test.service.arrayadder.ArrayAdderService;
import org.apache.airavata.xbaya.test.service.arraygen.ArrayGeneratorService;
import org.apache.airavata.xbaya.test.service.multiplier.MultiplierService;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;

public class JythonScriptTestCase
extends XBayaTestCase {
    private WorkflowCreator workflowCreator;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.workflowCreator = new WorkflowCreator();
    }

    public void testSimpleMath() throws IOException, WorkflowException {
        Workflow workflow = this.workflowCreator.createSimpleMathWorkflow();
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        String jythonString = script.getJythonString();
        String filename = "tmp/simple-math.py";
        IOUtil.writeToFile((String)jythonString, (String)filename);
        AdderService service = new AdderService();
        service.run();
        String adderWSDLLoc = service.getServiceWsdlLocation();
        String[] arguments = new String[]{"-Adder_add_wsdl", adderWSDLLoc};
        JythonRunner runner = new JythonRunner();
        runner.run(jythonString, arguments);
        service.shutdownServer();
    }

    public void testComplexMath() throws IOException, WorkflowException {
        Workflow workflow = this.workflowCreator.createComplexMathWorkflow();
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        String jythonString = script.getJythonString();
        String filename = "tmp/complex-math.py";
        IOUtil.writeToFile((String)jythonString, (String)filename);
        AdderService adder = new AdderService();
        adder.run();
        String adderWSDLLoc = adder.getServiceWsdlLocation();
        MultiplierService multiplier = new MultiplierService();
        multiplier.run();
        String multiplierWSDLLoc = multiplier.getServiceWsdlLocation();
        String[] arguments = new String[]{"-topic", "complex-math", "-Adder_add_wsdl", adderWSDLLoc, "-Adder_add_2_wsdl", adderWSDLLoc, "-Multiplier_multiply_wsdl", multiplierWSDLLoc};
        JythonRunner runner = new JythonRunner();
        runner.run(jythonString, arguments);
        adder.shutdownServer();
        multiplier.shutdownServer();
    }

    public void testArray() throws IOException, WorkflowException {
        Workflow workflow = this.workflowCreator.createArrayWorkflow();
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        String jythonString = script.getJythonString();
        String filename = "tmp/array-test.py";
        IOUtil.writeToFile((String)jythonString, (String)filename);
        ArrayGeneratorService arrayGenerator = new ArrayGeneratorService();
        arrayGenerator.run();
        String arrayGeneratorWSDLLoc = arrayGenerator.getServiceWsdlLocation();
        ArrayAdderService arrayAdder = new ArrayAdderService();
        arrayAdder.run();
        String arrayAdderWSDLLoc = arrayAdder.getServiceWsdlLocation();
        String[] arguments = new String[]{"-topic", "array-test", "-ArrayAdder_add_wsdl", arrayAdderWSDLLoc, "-ArrayGenerator_generate_wsdl", arrayGeneratorWSDLLoc};
        JythonRunner runner = new JythonRunner();
        runner.run(jythonString, arguments);
        arrayGenerator.shutdownServer();
        arrayAdder.shutdownServer();
    }
}

