/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.jython;

import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.jython.runner.JythonOneTimeRunnerImpl;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.service.adder.AdderService;
import org.apache.airavata.xbaya.test.service.multiplier.MultiplierService;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;

public class JythonOneTimeRunnerTestCase
extends XBayaTestCase {
    public void testRun() throws WorkflowException {
        WorkflowCreator creator = new WorkflowCreator();
        Workflow workflow = creator.createComplexMathWorkflow();
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        String jythonString = script.getJythonString();
        AdderService adder = new AdderService();
        adder.run();
        String adderWSDLLoc = adder.getServiceWsdlLocation();
        MultiplierService multiplier = new MultiplierService();
        multiplier.run();
        String multiplierWSDLLoc = multiplier.getServiceWsdlLocation();
        String[] arguments = new String[]{"-topic", "complex-math", "-Adder_wsdl", adderWSDLLoc, "-Adder_2_wsdl", adderWSDLLoc, "-Multiplier_wsdl", multiplierWSDLLoc};
        JythonOneTimeRunnerImpl runner = new JythonOneTimeRunnerImpl();
        runner.run(jythonString, arguments);
        try {
            runner.run(jythonString, arguments);
            JythonOneTimeRunnerTestCase.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        adder.shutdownServer();
        multiplier.shutdownServer();
    }
}

