/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test.jython;

import junit.framework.TestCase;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.jython.lib.NotificationSender;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.apache.airavata.xbaya.test.service.adder.AdderService;
import org.apache.airavata.xbaya.test.service.multiplier.MultiplierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonLibraryTest
extends TestCase {
    private static final Logger logger = LoggerFactory.getLogger(JythonLibraryTest.class);

    public void testSimpleMath() throws WorkflowException {
        AdderService service = new AdderService();
        service.run();
        String adderWSDLLoc = service.getServiceWsdlLocation();
        NotificationSender notifier = new NotificationSender(XBayaConstants.DEFAULT_BROKER_URL.toString(), "test-topic");
        GenericInvoker invoker = new GenericInvoker(null, adderWSDLLoc, "adder", null, null, (WorkflowNotifiable)notifier);
        invoker.setup();
        invoker.setOperation("add");
        invoker.setInput("x", 2);
        invoker.setInput("y", 3);
        invoker.invoke();
        Object output = invoker.getOutput("z");
        logger.info("z = " + output);
        service.shutdownServer();
    }

    public void testComplexMath() throws WorkflowException {
        AdderService adder = new AdderService();
        adder.run();
        String adderWSDLLoc = adder.getServiceWsdlLocation();
        MultiplierService multiplier = new MultiplierService();
        multiplier.run();
        String multiplierWSDLLoc = multiplier.getServiceWsdlLocation();
        NotificationSender notifier = new NotificationSender(XBayaConstants.DEFAULT_BROKER_URL.toString(), "test-topic");
        GenericInvoker adderInvoker1 = new GenericInvoker(null, adderWSDLLoc, "adder", null, null, (WorkflowNotifiable)notifier);
        adderInvoker1.setup();
        adderInvoker1.setOperation("add");
        adderInvoker1.setInput("x", 2);
        adderInvoker1.setInput("y", 3);
        adderInvoker1.invoke();
        Object output1 = adderInvoker1.getOutput("z");
        logger.info("output1 = " + output1);
        GenericInvoker adderInvoker2 = new GenericInvoker(null, adderWSDLLoc, "adder", null, null, (WorkflowNotifiable)notifier);
        adderInvoker2.setup();
        adderInvoker2.setOperation("add");
        adderInvoker2.setInput("x", 4);
        adderInvoker2.setInput("y", 5);
        adderInvoker2.invoke();
        Object output2 = adderInvoker2.getOutput("z");
        logger.info("output2 = " + output2);
        GenericInvoker multiplierInvoker = new GenericInvoker(null, multiplierWSDLLoc, "multiplier", null, null, (WorkflowNotifiable)notifier);
        multiplierInvoker.setup();
        multiplierInvoker.setOperation("multiply");
        multiplierInvoker.setInput("x", output1);
        multiplierInvoker.setInput("y", output2);
        multiplierInvoker.invoke();
        Object output3 = multiplierInvoker.getOutput("z");
        logger.info("output3 = " + output3);
        adder.shutdownServer();
        multiplier.shutdownServer();
    }
}

