/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.airavata.xbaya.XBayaConfiguration;

public abstract class XBayaTestCase
extends TestCase {
    protected XBayaConfiguration configuration;
    protected File temporalDirectory;

    protected void setUp() throws Exception {
        String myProxyPassphrase;
        String myProxyUsername;
        String dscURLString;
        String gpelURLString;
        super.setUp();
        this.configuration = new XBayaConfiguration();
        this.temporalDirectory = new File("tmp/");
        this.temporalDirectory.mkdir();
        if (this.configuration.getTopic() == null) {
            this.configuration.setTopic("xbaya-test");
        }
        if ((gpelURLString = System.getProperty("gpel.url")) != null) {
            this.configuration.setGPELEngineURL(URI.create(gpelURLString));
        }
        if ((dscURLString = System.getProperty("dsc.url")) != null) {
            this.configuration.setDSCURL(URI.create(dscURLString));
        }
        if ((myProxyUsername = System.getProperty("myproxy.username")) != null) {
            this.configuration.setMyProxyUsername(myProxyUsername);
        }
        if ((myProxyPassphrase = System.getProperty("myproxy.passphrase")) != null) {
            this.configuration.setMyProxyPassphrase(myProxyPassphrase);
        }
    }
}

