/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class WorkflowTestCase
extends XBayaTestCase {
    private static Logger logger = LoggerFactory.getLogger(WorkflowTestCase.class);
    private WorkflowCreator workflowCreator;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.workflowCreator = new WorkflowCreator();
    }

    public void testParse() throws IOException, GraphException, ComponentException {
        File file = new File(XBayaPathConstants.WORKFLOW_DIRECTORY, "complex-math.xwf");
        XmlElement workflowXML = XMLUtil.loadXML((File)file);
        Workflow workflow = new Workflow(workflowXML);
        WSGraph graph = workflow.getGraph();
        List inputNodes = GraphUtil.getInputNodes((Graph)graph);
        for (InputNode inputNode : inputNodes) {
            String inputName = inputNode.getName();
            logger.info("inputName: " + inputName);
            List nextNodes = GraphUtil.getNextNodes((Node)inputNode);
            for (Node nextNode : nextNodes) {
                String name = nextNode.getName();
                logger.info("name: " + name);
            }
        }
    }

    public void testSaveAndLoad() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createComplexMathWorkflow();
        XmlElement workflowElement = workflow.toXML();
        File file = new File(this.temporalDirectory, "complex-math.xwf");
        XMLUtil.saveXML((XmlElement)workflowElement, (File)file);
        XmlElement loadedWorkflowElement = XMLUtil.loadXML((File)file);
        Workflow loadedWorkflow = new Workflow(loadedWorkflowElement);
        WSGraph loadedGraph = loadedWorkflow.getGraph();
        Collection loadedWSNodes = GraphUtil.getWSNodes((Graph)loadedGraph);
        WorkflowTestCase.assertTrue((loadedWSNodes.size() != 0 ? 1 : 0) != 0);
        for (WSNode loadedWSNode : loadedWSNodes) {
            WorkflowTestCase.assertNotNull((Object)loadedWSNode.getComponent());
        }
    }
}

