/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.airavata.common.exception.UtilsException;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.component.local.LocalComponentRegistry;
import org.apache.airavata.workflow.model.component.system.OutputComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.gpel.DSCUtil;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.workflow.tracking.client.Callback;
import org.apache.airavata.workflow.tracking.client.NotificationType;
import org.apache.airavata.workflow.tracking.common.InvocationContext;
import org.apache.airavata.workflow.tracking.common.InvocationEntity;
import org.apache.airavata.workflow.tracking.common.WorkflowTrackingContext;
import org.apache.airavata.workflow.tracking.impl.NotifierImpl;
import org.apache.airavata.workflow.tracking.impl.publish.LoopbackPublisher;
import org.apache.airavata.workflow.tracking.impl.publish.NotificationPublisher;
import org.apache.airavata.ws.monitor.EventDataRepository;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.ws.monitor.event.Event;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.modifier.WorkflowModifier;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.service.adder.Adder;
import org.apache.airavata.xbaya.test.service.multiplier.Multiplier;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.view.XmlValidationException;
import org.xmlpull.v1.builder.XmlElement;
import xsul.soap11_util.Soap11Util;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.wsif.WSIFService;
import xsul.wsif.WSIFServiceFactory;
import xsul.xbeans_util.XBeansUtil;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;
import xsul5.wsdl.WsdlDefinitions;
import xsul5.wsdl.WsdlResolver;

public class WorkflowModificationTestCase
extends XBayaTestCase {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowModificationTestCase.class);
    private boolean gui = false;
    private XBayaEngine engine;
    private GraphCanvas graphCanvas;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String guiProperty = System.getProperty("xbaya.gui.test");
        this.gui = Boolean.parseBoolean(guiProperty);
    }

    public void test() throws IOException, ComponentException, GraphException, ComponentRegistryException, MonitorException {
        Monitor monitor;
        WorkflowCreator creator = new WorkflowCreator();
        Workflow workflow = creator.createComplexMathWorkflow();
        workflow.createScript();
        if (this.gui) {
            this.engine = new XBayaEngine(this.configuration);
            this.graphCanvas = this.engine.getGUI().getGraphCanvas();
            this.graphCanvas.setWorkflow(workflow);
            monitor = this.engine.getMonitor();
            this.engine.getGUI().eventReceived(new Event(Event.Type.MONITOR_STARTED));
            this.repaintAndWait(2);
        } else {
            MonitorConfiguration monitorConfiguration = new MonitorConfiguration(this.configuration.getBrokerURL(), this.configuration.getTopic(), this.configuration.isPullMode(), this.configuration.getMessageBoxURL());
            monitor = new Monitor(monitorConfiguration);
        }
        EventDataRepository eventData = monitor.getEventDataRepository();
        MonitorCallback callback = new MonitorCallback(eventData);
        LoopbackPublisher publisher = new LoopbackPublisher((Callback)callback, this.configuration.getTopic());
        MonitorNotifier notifier = new MonitorNotifier((NotificationPublisher)publisher);
        this.executeToMiddle(workflow, notifier);
        this.modifyWorkflow(workflow);
        File modifiedWorkflowFile = new File(this.temporalDirectory, "complex-math-modified.xwf");
        XMLUtil.saveXML((org.xmlpull.infoset.XmlElement)workflow.toXML(), (File)modifiedWorkflowFile);
        WorkflowModifier modifier = new WorkflowModifier(workflow, eventData);
        Workflow diffWorkflow = modifier.createDifference();
        if (this.gui) {
            GraphCanvas canvas = this.engine.getGUI().newGraphCanvas(true);
            canvas.setWorkflow(diffWorkflow);
            this.repaintAndWait(5);
        }
        File diffWorkflowFile = new File(this.temporalDirectory, "complex-math-diff.xwf");
        XMLUtil.saveXML((org.xmlpull.infoset.XmlElement)diffWorkflow.toXML(), (File)diffWorkflowFile);
    }

    private void executeToMiddle(Workflow workflow, MonitorNotifier notifier) throws XmlValidationException, ComponentException {
        WSGraph graph = workflow.getGraph();
        String adder1ID = "Adder_add";
        String adder2ID = "Adder_add_2";
        NodeImpl a = graph.getNode("a");
        NodeImpl b = graph.getNode("b");
        NodeImpl c = graph.getNode("c");
        NodeImpl d = graph.getNode("d");
        NodeImpl adder = graph.getNode(adder1ID);
        NodeImpl adder2 = graph.getNode(adder2ID);
        WsdlDefinitions workflowWSDL = workflow.getWorkflowWSDL();
        DSCUtil.convertToCWSDL((WsdlDefinitions)workflowWSDL, (URI)URI.create("http://example.com"));
        HashMap<String, String> inputMap = new HashMap<String, String>();
        inputMap.put("a", "2");
        inputMap.put("b", "3");
        inputMap.put("c", "4");
        inputMap.put("d", "5");
        try {
            this.sendNotification(workflowWSDL, null, WSDLUtil.getFirstOperation((WsdlDefinitions)workflowWSDL).getName(), inputMap, null, notifier);
        }
        catch (UtilsException e) {
            e.printStackTrace();
        }
        WsdlDefinitions adderWSDL = WsdlResolver.getInstance().loadWsdl(new File(XBayaPathConstants.WSDL_DIRECTORY + File.separator + Adder.WSDL_PATH).toURI());
        HashMap<String, String> inputMap1 = new HashMap<String, String>();
        inputMap1.put("x", "2");
        inputMap1.put("y", "3");
        HashMap<String, String> outputMap1 = new HashMap<String, String>();
        outputMap1.put("z", "5");
        this.sendNotification(adderWSDL, adder1ID, "add", inputMap1, outputMap1, notifier);
        a.setState(Node.NodeExecutionState.FINISHED);
        b.setState(Node.NodeExecutionState.FINISHED);
        adder.setState(Node.NodeExecutionState.FINISHED);
        this.repaintAndWait(3);
        HashMap<String, String> inputMap2 = new HashMap<String, String>();
        inputMap2.put("x", "4");
        inputMap2.put("y", "5");
        HashMap<String, String> outputMap2 = new HashMap<String, String>();
        outputMap2.put("z", "9");
        this.sendNotification(adderWSDL, adder2ID, "add", inputMap2, outputMap2, notifier);
        c.setState(Node.NodeExecutionState.FINISHED);
        d.setState(Node.NodeExecutionState.FINISHED);
        adder2.setState(Node.NodeExecutionState.FINISHED);
        this.repaintAndWait(3);
    }

    private void modifyWorkflow(Workflow workflow) throws ComponentException, ComponentRegistryException, GraphException {
        WSGraph graph = workflow.getGraph();
        OutputComponent outputComponent = new OutputComponent();
        LocalComponentRegistry registry = new LocalComponentRegistry(XBayaPathConstants.WSDL_DIRECTORY);
        WSComponent adderComponent = registry.getComponent(Adder.WSDL_PATH);
        WSComponent multiplierComponent = registry.getComponent(Multiplier.WSDL_PATH);
        NodeImpl c = graph.getNode("c");
        NodeImpl d = graph.getNode("d");
        NodeImpl adder = graph.getNode("Adder_add");
        NodeImpl adder2 = graph.getNode("Adder_add_2");
        NodeImpl multiplier = graph.getNode("Multiplier_multiply");
        graph.removeNode((Node)adder2);
        this.repaintAndWait(1);
        Node multiplier2 = workflow.addNode((Component)multiplierComponent);
        multiplier2.setPosition(new Point(170, 210));
        this.repaintAndWait(1);
        graph.addEdge((Port)c.getOutputPort(0), (Port)multiplier2.getInputPort(0));
        this.repaintAndWait(1);
        graph.addEdge((Port)d.getOutputPort(0), (Port)multiplier2.getInputPort(1));
        this.repaintAndWait(1);
        graph.addEdge(multiplier2.getOutputPort(0), (Port)multiplier.getInputPort(1));
        this.repaintAndWait(1);
        Node adder3 = workflow.addNode((Component)adderComponent);
        adder3.setPosition(new Point(320, 300));
        this.repaintAndWait(1);
        graph.addEdge((Port)adder.getOutputPort(0), (Port)adder3.getInputPort(0));
        this.repaintAndWait(1);
        graph.addEdge(multiplier2.getOutputPort(0), (Port)adder3.getInputPort(1));
        this.repaintAndWait(1);
        Node output2 = workflow.addNode((Component)outputComponent);
        output2.setPosition(new Point(500, 300));
        this.repaintAndWait(1);
        graph.addEdge(adder3.getOutputPort(0), (Port)output2.getInputPort(0));
        this.repaintAndWait(1);
    }

    private void sendNotification(WsdlDefinitions definitions, String nodeID, String operationName, Map<String, String> inputMap, Map<String, String> outputMap, MonitorNotifier notifier) {
        WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
        WSIFService service = factory.getService(WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)definitions));
        WSIFClient client = WSIFRuntime.getDefault().newClientFor(service, null);
        WSIFPort port = client.getPort();
        WSIFOperation operation = port.createOperation(operationName);
        WSIFMessage inputMessage = operation.createInputMessage();
        for (String key : inputMap.keySet()) {
            String value = inputMap.get(key);
            inputMessage.setObjectPart(key, (Object)value);
        }
        URI myWorkflowID = null;
        URI myServiceID = URI.create("XBaya");
        String myNodeID = null;
        Integer myTimestep = null;
        InvocationEntity myEntity = notifier.createEntity(myWorkflowID, myServiceID, myNodeID, myTimestep);
        URI serviceWorkflowID = null;
        URI serviceServiceID = URI.create("ServiceID");
        String serviceNodeID = nodeID;
        Integer serviceTimestep = null;
        InvocationEntity serviceEntity = notifier.createEntity(serviceWorkflowID, serviceServiceID, serviceNodeID, serviceTimestep);
        WorkflowTrackingContext workflowContext = notifier.createTrackingContext(new Properties(), this.configuration.getBrokerURL().toASCIIString(), myWorkflowID, myServiceID, myNodeID, myTimestep);
        XmlElement inputBody = (XmlElement)((XmlElement)inputMessage).getParent();
        XmlObject inputBodyObject = XBeansUtil.xmlElementToXmlObject((XmlElement)inputBody);
        InvocationContext context = notifier.invokingService(workflowContext, serviceEntity, null, inputBodyObject, new String[0]);
        if (outputMap != null) {
            WSIFMessage outputMessage = operation.createOutputMessage();
            Soap11Util.getInstance().wrapBodyContent((XmlElement)outputMessage);
            for (String key : outputMap.keySet()) {
                String value = outputMap.get(key);
                outputMessage.setObjectPart(key, (Object)value);
            }
            XmlElement outputBody = (XmlElement)((XmlElement)outputMessage).getParent();
            XmlObject outputBodyObject = XBeansUtil.xmlElementToXmlObject((XmlElement)outputBody);
            notifier.receivedResult(workflowContext, context, null, outputBodyObject, new String[0]);
        }
    }

    private void repaintAndWait(int second) {
        if (this.gui) {
            this.graphCanvas.repaint();
            try {
                Thread.sleep(second * 1000);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class MonitorCallback
    implements Callback {
        private EventDataRepository eventData;

        public MonitorCallback(EventDataRepository eventData) {
            this.eventData = eventData;
        }

        public void deliverMessage(String topic, NotificationType type, XmlObject message) {
            XmlElement event = XBeansUtil.xmlObjectToXmlElement((XmlObject)message);
            this.eventData.addEvent(XMLUtil.xmlElement3ToXmlElement5((XmlElement)event));
        }
    }

    private class MonitorNotifier
    extends NotifierImpl {
        public MonitorNotifier(NotificationPublisher publisher) {
        }
    }
}

