/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.system.InputComponent;
import org.apache.airavata.workflow.model.component.system.OutputComponent;
import org.apache.airavata.workflow.model.component.web.WebComponentRegistry;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.xmlpull.infoset.XmlElement;

public class WebComponentRegistryClientTestCase
extends XBayaTestCase {
    private static final String MATH_ADDER_WSDL = "adder-wsdl.xml";
    private static final String MATH_MULTIPLIER_WSDL = "multiplier-wsdl.xml";
    private Component inputComponent;
    private Component outputComponent;
    private WebComponentRegistry componentRegistry;
    private File temporaryDirectory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.temporaryDirectory = new File("tmp");
        this.temporaryDirectory.mkdir();
        this.componentRegistry = new WebComponentRegistry(XBayaConstants.DEFAULT_WEB_REGISTRY.toURL());
        this.componentRegistry.getComponentReferenceList();
        this.inputComponent = new InputComponent();
        this.outputComponent = new OutputComponent();
    }

    public void testComplexMath() throws GraphException, ComponentException, IOException {
        Workflow workflow = this.createComplexMathWorkflow();
        File workflowFile = new File(this.temporaryDirectory, "web-complex-math.xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)workflowFile);
        XmlElement workflowElement = XMLUtil.loadXML((File)workflowFile);
        Workflow workflow2 = new Workflow(workflowElement);
        File workflowFile2 = new File(this.temporaryDirectory, "web-complex-math-2.xwf");
        XMLUtil.saveXML((XmlElement)workflow2.toXML(), (File)workflowFile2);
        String workflowFileString = IOUtil.readFileToString((File)workflowFile);
        String workflowFile2String = IOUtil.readFileToString((File)workflowFile2);
        WebComponentRegistryClientTestCase.assertEquals((String)workflowFileString, (String)workflowFile2String);
        File jythonFile = new File(this.temporaryDirectory, "web-complex-math.py");
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        IOUtil.writeToFile((String)script.getJythonString(), (File)jythonFile);
    }

    private Workflow createComplexMathWorkflow() throws GraphException {
        Workflow workflow = new Workflow();
        workflow.setName("Complex math workflow");
        workflow.setDescription("Complex math workflow");
        WSGraph graph = workflow.getGraph();
        Component adderComp = (Component)this.componentRegistry.getComponents(MATH_ADDER_WSDL).get(0);
        Node adderNode1 = workflow.addNode(adderComp);
        adderNode1.setPosition(new Point(170, 50));
        Node adderNode2 = workflow.addNode(adderComp);
        adderNode2.setPosition(new Point(170, 210));
        Component multiComp = (Component)this.componentRegistry.getComponents(MATH_MULTIPLIER_WSDL).get(0);
        Node multiNode = workflow.addNode(multiComp);
        multiNode.setPosition(new Point(320, 130));
        InputNode paramNode1 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode1.setPosition(new Point(20, 30));
        String paramValue1 = "2";
        paramNode1.setDefaultValue((Object)paramValue1);
        InputNode paramNode2 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode2.setPosition(new Point(20, 100));
        String paramValue2 = "3";
        paramNode2.setDefaultValue((Object)paramValue2);
        InputNode paramNode3 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode3.setPosition(new Point(20, 170));
        String paramValue3 = "4";
        paramNode3.setDefaultValue((Object)paramValue3);
        InputNode paramNode4 = (InputNode)workflow.addNode(this.inputComponent);
        paramNode4.setPosition(new Point(20, 240));
        String paramValue4 = "5";
        paramNode4.setDefaultValue((Object)paramValue4);
        OutputNode outParamNode = (OutputNode)workflow.addNode(this.outputComponent);
        outParamNode.setPosition(new Point(370, 240));
        graph.addEdge((Port)paramNode1.getOutputPort(0), (Port)adderNode1.getInputPort(0));
        graph.addEdge((Port)paramNode2.getOutputPort(0), (Port)adderNode1.getInputPort(1));
        graph.addEdge((Port)paramNode3.getOutputPort(0), (Port)adderNode2.getInputPort(0));
        graph.addEdge((Port)paramNode4.getOutputPort(0), (Port)adderNode2.getInputPort(1));
        graph.addEdge(adderNode1.getOutputPort(0), (Port)multiNode.getInputPort(0));
        graph.addEdge(adderNode2.getOutputPort(0), (Port)multiNode.getInputPort(1));
        graph.addEdge(multiNode.getOutputPort(0), (Port)outParamNode.getInputPort(0));
        return workflow;
    }
}

