/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.io.IOException;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;
import org.xmlpull.infoset.XmlElement;

public class WSDLTestCase
extends XBayaTestCase {
    private WorkflowCreator graphCreater;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File tmpDir = new File("tmp");
        tmpDir.mkdir();
        this.graphCreater = new WorkflowCreator();
    }

    public void testSimpleMath() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.graphCreater.createSimpleMathWorkflow();
        File workflowFile = new File("tmp/simple-math.xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)workflowFile);
        File jythonFile = new File("tmp/simple-math.py");
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        IOUtil.writeToFile((String)script.getJythonString(), (File)jythonFile);
    }

    public void testComplexMath() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.graphCreater.createComplexMathWorkflow();
        File graphFile = new File("tmp/complex-math.xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)graphFile);
        File jythonFile = new File("tmp/complex-math.py");
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        IOUtil.writeToFile((String)script.getJythonString(), (File)jythonFile);
    }
}

