/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.component.local.LocalComponentRegistry;
import org.apache.airavata.workflow.model.component.system.InputComponent;
import org.apache.airavata.workflow.model.component.system.OutputComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponentPort;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class MetadataTestCase
extends TestCase {
    private static final String WSDL_DIRECTORY = "/u/sshirasu/codes/appservices/gfac2/wsdls";
    private static final String WRF_STATIC_PREPROCESSOR_WSDL = "WrfStaticPreprocessor.wsdl";
    private static final String TERRAIN_PREPROCESSOR_WSDL = "TerrainPreprocessor.wsdl";
    private static final String ADAS_INTERPOLATOR_WSDL = "ADASInterpolator.wsdl";
    private static final String LATERAL_BOUNDARY_INTERPOLATOR_WSDL = "LateralBoundaryInterpolator.wsdl";
    private static final String ARPS2WRF_INTERPOLATOR_WSDL = "ARPS2WRFInterpolator.wsdl";
    private static final String WRF_FORECASTING_MODEL_WSDL = "WRFForecastingModel.wsdl";
    private static final Logger logger = LoggerFactory.getLogger(MetadataTestCase.class);

    public void testWorkflow() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.createWorkflow();
        File workflowFile = new File("tmp/ADASInitializedWRFForecast.xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)workflowFile);
    }

    public void testPreInvoke() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.createWorkflow();
        workflow.createScript();
        File workflowWSDLFile = new File("tmp/ADASInitializedWRFForecast-wsdl.xml");
        XMLUtil.saveXML((XmlElement)workflow.getWorkflowWSDL().xml(), (File)workflowWSDLFile);
        File bpelFile = new File("tmp/ADASInitializedWRFForecast-bpel.xml");
        XMLUtil.saveXML((XmlElement)workflow.getGpelProcess().xml(), (File)bpelFile);
        XmlElement inputAppinfo = workflow.getInputMetadata();
        List inputs = workflow.getInputs();
        for (WSComponentPort input : inputs) {
            String name = input.getName();
            logger.info("name: " + name);
            QName type = input.getType();
            logger.info("type: " + type);
            XmlElement appinfo = input.getAppinfo();
            logger.info("appinfo: " + XMLUtil.xmlElementToString((XmlElement)appinfo));
            if (appinfo != null) {
                for (XmlElement element : appinfo.requiredElementContent()) {
                    String tag = element.getName();
                    String value = element.requiredText();
                    logger.info(tag + " = " + value);
                }
            }
            input.setValue((Object)"200");
        }
    }

    private Workflow createWorkflow() throws ComponentException, GraphException, ComponentRegistryException {
        Workflow workflow = new Workflow();
        workflow.setName("ADASInitializedWRFForecast");
        workflow.setDescription("");
        WSGraph graph = workflow.getGraph();
        LocalComponentRegistry componentRegistry = new LocalComponentRegistry(WSDL_DIRECTORY);
        WSComponent wrfPreComp = componentRegistry.getComponent(WRF_STATIC_PREPROCESSOR_WSDL);
        Node wrfPreNode = workflow.addNode((Component)wrfPreComp);
        wrfPreNode.setPosition(new Point(313, 0));
        WSComponent terrainPreComp = componentRegistry.getComponent(TERRAIN_PREPROCESSOR_WSDL);
        Node terrainPreNode = workflow.addNode((Component)terrainPreComp);
        terrainPreNode.setPosition(new Point(59, 289));
        WSComponent adasIntComp = componentRegistry.getComponent(ADAS_INTERPOLATOR_WSDL);
        Node adasIntNode = workflow.addNode((Component)adasIntComp);
        adasIntNode.setPosition(new Point(373, 235));
        WSComponent lateralIntComp = componentRegistry.getComponent(LATERAL_BOUNDARY_INTERPOLATOR_WSDL);
        Node lateralIntNode = workflow.addNode((Component)lateralIntComp);
        lateralIntNode.setPosition(new Point(371, 369));
        WSComponent arp2wrfComp = componentRegistry.getComponent(ARPS2WRF_INTERPOLATOR_WSDL);
        Node arp2wrfNode = workflow.addNode((Component)arp2wrfComp);
        arp2wrfNode.setPosition(new Point(607, 104));
        WSComponent wrfComp = componentRegistry.getComponent(WRF_FORECASTING_MODEL_WSDL);
        Node wrfNode = workflow.addNode((Component)wrfComp);
        wrfNode.setPosition(new Point(781, 14));
        InputComponent inputComponent = new InputComponent();
        OutputComponent outputComponent = new OutputComponent();
        InputNode confInput = (InputNode)workflow.addNode((Component)inputComponent);
        confInput.setPosition(new Point(0, 100));
        InputNode adasInput = (InputNode)workflow.addNode((Component)inputComponent);
        adasInput.setPosition(new Point(286, 145));
        InputNode namInput = (InputNode)workflow.addNode((Component)inputComponent);
        namInput.setPosition(new Point(179, 438));
        OutputNode outParamNode = (OutputNode)workflow.addNode((Component)outputComponent);
        outParamNode.setPosition(new Point(863, 169));
        graph.addEdge((Port)confInput.getOutputPort(0), (Port)wrfPreNode.getInputPort(0));
        graph.addEdge((Port)confInput.getOutputPort(0), (Port)arp2wrfNode.getInputPort(0));
        graph.addEdge((Port)confInput.getOutputPort(0), (Port)adasIntNode.getInputPort(1));
        graph.addEdge((Port)confInput.getOutputPort(0), (Port)lateralIntNode.getInputPort(1));
        graph.addEdge((Port)confInput.getOutputPort(0), (Port)terrainPreNode.getInputPort(0));
        graph.addEdge(terrainPreNode.getOutputPort(0), (Port)adasIntNode.getInputPort(2));
        graph.addEdge(terrainPreNode.getOutputPort(0), (Port)lateralIntNode.getInputPort(0));
        graph.addEdge((Port)adasInput.getOutputPort(0), (Port)adasIntNode.getInputPort(0));
        graph.addEdge((Port)namInput.getOutputPort(0), (Port)lateralIntNode.getInputPort(2));
        graph.addEdge(wrfPreNode.getOutputPort(0), (Port)arp2wrfNode.getInputPort(1));
        graph.addEdge(adasIntNode.getOutputPort(0), (Port)arp2wrfNode.getInputPort(2));
        graph.addEdge(lateralIntNode.getOutputPort(0), (Port)arp2wrfNode.getInputPort(3));
        graph.addEdge(arp2wrfNode.getOutputPort(0), (Port)wrfNode.getInputPort(0));
        graph.addEdge(wrfNode.getOutputPort(0), (Port)outParamNode.getInputPort(0));
        String inputMetadata = "<appinfo xmlns:lsm=\"http://www.extreme.indiana.edu/namespaces/2006/lead-service-metadata\"><lsm:constraints><lsm:constraint type=\"temporalSync\"><lsm:elementref name=\"ADASDataFiles\" /><lsm:elementref name=\"NAMDataFiles\" /></lsm:constraint></lsm:constraints></appinfo>";
        graph.setInputMetadata(XMLUtil.stringToXmlElement((String)inputMetadata));
        return workflow;
    }
}

