/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ws.WSComponentPort;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.gpel.DSCUtil;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.lead.LEADWorkflowInvoker;
import org.apache.airavata.xbaya.lead.LeadContextHeaderHelper;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.service.adder.Adder;
import org.apache.airavata.xbaya.test.service.adder.AdderService;
import org.globus.gsi.CertUtil;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import xsul.invoker.gsi.GsiInvoker;
import xsul.invoker.puretls.PuretlsInvoker;
import xsul.lead.LeadContextHeader;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.wsif.WSIFService;
import xsul.wsif.WSIFServiceFactory;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;
import xsul5.wsdl.WsdlDefinitions;
import xsul5.wsdl.WsdlException;
import xsul5.wsdl.WsdlResolver;

public class LEADWorkflowInvokerTestCase
extends XBayaTestCase {
    private static final String SAMPLE_AWSDL = XBayaPathConstants.WSDL_DIRECTORY + File.separator + Adder.WSDL_PATH;
    private static final Logger logger = LoggerFactory.getLogger(LEADWorkflowInvokerTestCase.class);

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(LEADWorkflowInvokerTestCase.class));
    }

    public void estWSIFINvoker() {
        WsdlDefinitions definitions = WsdlResolver.getInstance().loadWsdl(new File(SAMPLE_AWSDL).toURI());
        WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
        WSIFService service = factory.getService(WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)definitions));
        WSIFClient client = WSIFRuntime.getDefault().newClientFor(service, null);
        WSIFPort port = client.getPort();
        WSIFOperation operation = port.createOperation("add");
        WSIFMessage inputMessage = operation.createInputMessage();
        WSIFMessage outputMessage = operation.createOutputMessage();
        WSIFMessage faultMessage = operation.createFaultMessage();
        inputMessage.setObjectPart("x", (Object)"2");
        inputMessage.setObjectPart("y", (Object)"3");
        XmlElement xmlEl = (XmlElement)inputMessage;
        XmlContainer top = xmlEl.getRoot();
        String xmlAsStr = XMLUtil.BUILDER3.serializeToString((Object)top);
        System.out.println(xmlAsStr);
        XmlDocument doc = (XmlDocument)((XmlElement)inputMessage).getRoot();
        XmlElement env = doc.getDocumentElement();
        XmlElement header = env.element(env.getNamespace(), "Header");
        if (header == null) {
            header = env.newElement(env.getNamespace(), "Header");
            env.addElement(0, header);
        }
        header.addElement(LeadContextHeader.NS, LeadContextHeader.TYPE.getLocalPart());
        boolean success = operation.executeRequestResponseOperation(inputMessage, outputMessage, faultMessage);
        XmlElement xmlEl2 = (XmlElement)inputMessage;
        XmlContainer top2 = xmlEl2.getRoot();
        String xmlAsStr2 = XMLUtil.BUILDER3.serializeToString((Object)top2);
        System.out.println(xmlAsStr2);
        if (success) {
            logger.info("outputMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)outputMessage)));
        } else {
            logger.info("faultMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)faultMessage)));
        }
    }

    public void test() throws WsdlException, WorkflowException {
        AdderService service = new AdderService();
        service.run();
        WsdlDefinitions definitions = WSDLUtil.wsdlDefinitions3ToWsdlDefintions5((xsul.wsdl.WsdlDefinitions)service.getWsdl());
        if (WSDLUtil.isAWSDL((WsdlDefinitions)definitions)) {
            DSCUtil.convertToCWSDL((WsdlDefinitions)definitions, (URI)this.configuration.getDSCURL());
        }
        logger.info(definitions.xmlStringPretty());
        LeadContextHeaderHelper leadContextHelper = new LeadContextHeaderHelper();
        leadContextHelper.setXBayaConfiguration(this.configuration);
        LeadContextHeader leadContext = leadContextHelper.getLeadContextHeader();
        URI messageBoxURL = null;
        if (this.configuration.isPullMode()) {
            messageBoxURL = this.configuration.getMessageBoxURL();
        }
        LEADWorkflowInvoker invoker = new LEADWorkflowInvoker(definitions, leadContext, messageBoxURL);
        List<WSComponentPort> inputs = invoker.getInputs();
        for (WSComponentPort input : inputs) {
            String name = input.getName();
            logger.info("name: " + name);
            input.setValue((Object)"200");
            org.xmlpull.infoset.XmlElement appinfo = input.getAppinfo();
            logger.info("appinfo: " + XMLUtil.xmlElementToString((org.xmlpull.infoset.XmlElement)appinfo));
        }
        invoker.setInputs(inputs);
        boolean success = invoker.invoke();
        logger.info("success: " + success);
        if (success) {
            List<WSComponentPort> outputs = invoker.getOutputs();
            for (WSComponentPort output : outputs) {
                String name = output.getName();
                logger.info("name: " + name);
                Object value = output.getValue();
                logger.info("value: " + value);
            }
        } else {
            WSIFMessage fault = invoker.getFault();
            logger.info("fault: " + fault);
        }
        service.shutdownServer();
    }

    public void estWithUserCredential() throws ComponentException, IOException, GeneralSecurityException {
        boolean userCred = true;
        GSSCredential proxy = null;
        WsdlDefinitions wsdl = null;
        LeadContextHeader leadContext = null;
        URI messageBoxURL = null;
        String trustedcerts = System.getProperty("trustedcerts");
        String certskey = System.getProperty("certskey");
        Object secureInvoker = userCred ? new GsiInvoker(proxy, CertUtil.loadCertificates((String)trustedcerts)) : new PuretlsInvoker(certskey, "", trustedcerts);
        LEADWorkflowInvoker workflowInvoker = new LEADWorkflowInvoker(wsdl, leadContext, messageBoxURL, (PuretlsInvoker)secureInvoker);
        LEADWorkflowInvokerTestCase.assertNotNull((Object)workflowInvoker);
    }
}

