/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.jython.lib.GFacServiceCreator;
import org.apache.airavata.xbaya.jython.lib.NotificationSender;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class GFacServiceCreaterTestCase
extends XBayaTestCase {
    private static final String TEST_SERVICE_QNAME = "{http://www.extreme.indiana.edu/lead}TestCMD_Simple";
    private static final String TEST_AWSDL = XBayaPathConstants.WSDL_DIRECTORY + File.separator + "TestCMD_Example1_AWSDL.xml";
    private static final Logger logger = LoggerFactory.getLogger(GFacServiceCreaterTestCase.class);

    public void testCreate() throws WorkflowException {
        URI gFacURL = this.configuration.getGFacURL();
        URI gFacWSDLURL = WSDLUtil.appendWSDLQuary((URI)gFacURL);
        GFacServiceCreator creator = new GFacServiceCreator(gFacWSDLURL);
        creator.createService(TEST_SERVICE_QNAME);
        creator.shutdownService();
    }

    public void testService() throws WorkflowException {
        NotificationSender notifier = new NotificationSender(this.configuration.getBrokerURL(), "test-topic2");
        GenericInvoker invoker = new GenericInvoker(QName.valueOf(TEST_SERVICE_QNAME), TEST_AWSDL, "test-node", null, this.configuration.getGFacURL().toString(), (WorkflowNotifiable)notifier);
        invoker.setup();
        invoker.setOperation("Run");
        invoker.setInput("inparam1", "test");
        invoker.invoke();
        Object output = invoker.getOutput("outparam1");
        logger.info("output: " + output);
    }

    public void testWorkflow() throws ComponentException, IOException, GraphException, InterruptedException, ComponentRegistryException {
        WorkflowCreator creator = new WorkflowCreator();
        Workflow workflow = creator.createGFacWorkflow();
        File workflowFile = new File("tmp/gfac-test.xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)workflowFile);
        JythonScript script = new JythonScript(workflow, this.configuration);
        script.create();
        String jythonString = script.getJythonString();
        String filename = "tmp/gfac-test.py";
        IOUtil.writeToFile((String)jythonString, (String)filename);
        String[] commands = new String[]{"./jython.sh", filename, "-TestCMD_Simple_wsdl", TEST_AWSDL};
        Process process = Runtime.getRuntime().exec(commands);
        int exitValue = process.waitFor();
        logger.info("Exit value: " + exitValue);
        InputStream inputStream = process.getInputStream();
        String output = IOUtil.readToString((InputStream)inputStream);
        logger.info("output: " + output);
        InputStream errorStream = process.getErrorStream();
        String error = IOUtil.readToString((InputStream)errorStream);
        logger.info("error: " + error);
    }
}

