/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.net.URI;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.gpel.DSCUtil;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xsul5.wsdl.WsdlDefinitions;
import xsul5.wsdl.WsdlException;
import xsul5.wsdl.WsdlResolver;

public class DSCUtilTestCase
extends XBayaTestCase {
    private static final String SAMPLE_AWSDL = XBayaPathConstants.WSDL_DIRECTORY + "/test/adder-awsdl.xml";
    private static final String WSDL_WITH_MULTIPLE_PORT_TYPES = XBayaPathConstants.BPEL_SCRIPT_DIRECTORY + File.separator + "receive-test-wsdl.xml";
    private static final Logger logger = LoggerFactory.getLogger(DSCUtilTestCase.class);

    public void testConvertToCWSDL() throws WsdlException {
        WsdlDefinitions definitions = WsdlResolver.getInstance().loadWsdl(new File(".").toURI(), new File(SAMPLE_AWSDL).toURI());
        DSCUtil.convertToCWSDL((WsdlDefinitions)definitions, (URI)this.configuration.getDSCURL());
        logger.info(definitions.xmlStringPretty());
    }

    public void testMultiplePortTypes() {
        WsdlDefinitions definitions = WsdlResolver.getInstance().loadWsdl(new File(".").toURI(), new File(WSDL_WITH_MULTIPLE_PORT_TYPES).toURI());
        DSCUtil.convertToCWSDL((WsdlDefinitions)definitions, (URI)this.configuration.getDSCURL());
        logger.info(definitions.xmlStringPretty());
    }

    public void testConvertToCWSDLs() throws ComponentException, GraphException, ComponentRegistryException {
        WorkflowCreator creator = new WorkflowCreator();
        Workflow workflow = creator.createComplexMathWorkflow();
        DSCUtil.createCWSDLs((Workflow)workflow, (URI)this.configuration.getDSCURL());
    }
}

