/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.gpel.DSCUtil;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.lead.LeadContextHeaderHelper;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.util.XsulUtil;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;
import xsul.xwsif_runtime_async.WSIFAsyncResponsesCorrelator;
import xsul.xwsif_runtime_async_http.XsulSoapHttpWsaResponsesCorrelator;
import xsul5.wsdl.WsdlDefinitions;
import xsul5.wsdl.WsdlException;
import xsul5.wsdl.WsdlResolver;

public class DSCTestCase
extends XBayaTestCase {
    private static final String SAMPLE_AWSDL = XBayaPathConstants.WSDL_DIRECTORY + "/test/TestCMD_Example1_AWSDL.xml";
    private static final Logger logger = LoggerFactory.getLogger(DSCTestCase.class);

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(DSCTestCase.class));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test() throws WsdlException {
        WsdlDefinitions definitions = WsdlResolver.getInstance().loadWsdl(new File(".").toURI(), new File(SAMPLE_AWSDL).toURI());
        URI dscURL = this.configuration.getDSCURL();
        logger.info("dscURL: " + dscURL);
        DSCUtil.convertToCWSDL((WsdlDefinitions)definitions, (URI)dscURL);
        logger.info(definitions.xmlStringPretty());
        int clientPort = 0;
        XsulSoapHttpWsaResponsesCorrelator correlator = new XsulSoapHttpWsaResponsesCorrelator(clientPort);
        String serverLoc = correlator.getServerLocation();
        logger.info("client is waiting at " + serverLoc);
        LeadContextHeaderHelper leadContextHelper = new LeadContextHeaderHelper();
        leadContextHelper.setXBayaConfiguration(this.configuration);
        LeadContextHeader leadContext = leadContextHelper.getLeadContextHeader();
        leadContext.setWorkflowId(URI.create("http://host/2005/11/09/workflowinstace"));
        leadContext.setNodeId("decoder1");
        leadContext.setTimeStep("5");
        leadContext.setServiceInstanceId(URI.create("decoder-instance-10"));
        XmlElement element3 = XMLUtil.xmlElement5ToXmlElement3((org.xmlpull.infoset.XmlElement)definitions.xml());
        xsul.wsdl.WsdlDefinitions definitions3 = new xsul.wsdl.WsdlDefinitions(element3);
        WSIFClient wclient = WSIFRuntime.getDefault().newClientFor(definitions3, "TestCMD_Example1SoapPort");
        StickySoapHeaderHandler handler = new StickySoapHeaderHandler("use-lead-header", (XmlElement)leadContext);
        wclient.addHandler((XHandler)handler);
        wclient.useAsyncMessaging((WSIFAsyncResponsesCorrelator)correlator);
        wclient.setAsyncResponseTimeoutInMs(33000L);
        WSIFPort port = wclient.getPort();
        WSIFOperation operation = port.createOperation("Run");
        WSIFMessage inputMessage = operation.createInputMessage();
        WSIFMessage outputMessage = operation.createOutputMessage();
        WSIFMessage faultMessage = operation.createFaultMessage();
        inputMessage.setObjectPart("InputParam1", (Object)"100");
        logger.info("inputMessage: " + XsulUtil.safeXmlToString((XmlElement)((XmlElement)inputMessage)));
        boolean success = operation.executeRequestResponseOperation(inputMessage, outputMessage, faultMessage);
        XmlElement result = success ? (XmlElement)outputMessage : (XmlElement)faultMessage;
        logger.info("result:\n" + XsulUtil.safeXmlToString((XmlElement)result));
    }
}

