/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.test;

import java.io.File;
import java.io.IOException;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.gpel.script.BPELScript;
import org.apache.airavata.workflow.model.gpel.script.BPELScriptType;
import org.apache.airavata.workflow.model.gpel.script.WorkflowWSDL;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.test.XBayaTestCase;
import org.apache.airavata.xbaya.test.util.WorkflowCreator;
import org.gpel.model.GpelProcess;
import org.xmlpull.infoset.XmlElement;
import xsul5.wsdl.WsdlDefinitions;

public class BPELScriptTestCase
extends XBayaTestCase {
    private WorkflowCreator workflowCreator;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.workflowCreator = new WorkflowCreator();
    }

    public void testSimpleMath() throws ComponentException, IOException, GraphException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createSimpleMathWorkflow();
        this.testWrokflow(workflow, "simple-math");
    }

    public void testMath() throws ComponentException, IOException, GraphException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createMathWorkflow();
        this.testWrokflow(workflow, "math");
    }

    public void testComplexMath() throws ComponentException, IOException, GraphException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createComplexMathWorkflow();
        this.testWrokflow(workflow, "complex-math");
    }

    public void testMathWithConstant() throws ComponentException, IOException, GraphException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createMathWithConstWorkflow();
        this.testWrokflow(workflow, "constant-test");
    }

    public void testArray() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createArrayWorkflow();
        this.testWrokflow(workflow, "array-test");
    }

    public void testForEach() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createForEachWorkflow();
        this.testWrokflow(workflow, "foreach-test");
    }

    public void testIf() throws ComponentException, GraphException, IOException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createIfWorkflow();
        this.testWrokflow(workflow, "if-test");
    }

    public void testReceive() throws GraphException, ComponentException, IOException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createReceiveWorkflow();
        this.testWrokflow(workflow, "receive-test");
    }

    public void testLoan() throws GraphException, ComponentException, IOException, ComponentRegistryException {
        Workflow workflow = this.workflowCreator.createLoanWorkflow();
        this.testWrokflow(workflow, "loan");
    }

    private void testWrokflow(Workflow workflow, String filename) throws GraphException, IOException, ComponentException {
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)new File(this.temporalDirectory, filename + "-0.xwf"));
        BPELScript bpel = new BPELScript(workflow);
        bpel.create(BPELScriptType.GPEL);
        GpelProcess gpelProcess = bpel.getGpelProcess();
        WorkflowWSDL workflowWSDL = bpel.getWorkflowWSDL();
        WsdlDefinitions definitions = workflowWSDL.getWsdlDefinitions();
        File bpelFile = new File(this.temporalDirectory, filename + ".bpel");
        File wsdlFile = new File(this.temporalDirectory, filename + ".wsdl");
        XMLUtil.saveXML((XmlElement)gpelProcess.xml(), (File)bpelFile);
        XMLUtil.saveXML((XmlElement)definitions.xml(), (File)wsdlFile);
        File workflowFile = new File(this.temporalDirectory, filename + ".xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)workflowFile);
        XmlElement workflowElement = XMLUtil.loadXML((File)workflowFile);
        workflow = new Workflow(workflowElement);
        bpel = new BPELScript(workflow);
        bpel.create(BPELScriptType.GPEL);
        gpelProcess = bpel.getGpelProcess();
        workflowWSDL = bpel.getWorkflowWSDL();
        definitions = workflowWSDL.getWsdlDefinitions();
        File bpelFile2 = new File(this.temporalDirectory, filename + "-2" + ".bpel");
        File wsdlFile2 = new File(this.temporalDirectory, filename + "-2" + ".wsdl");
        XMLUtil.saveXML((XmlElement)gpelProcess.xml(), (File)bpelFile2);
        XMLUtil.saveXML((XmlElement)definitions.xml(), (File)wsdlFile2);
        File workflowFile2 = new File(this.temporalDirectory, filename + "-2" + ".xwf");
        XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)workflowFile2);
        String workflowString = IOUtil.readFileToString((File)workflowFile);
        String workflowString2 = IOUtil.readFileToString((File)workflowFile2);
        BPELScriptTestCase.assertEquals((String)workflowString, (String)workflowString2);
        String bpelString = IOUtil.readFileToString((File)bpelFile);
        String bpelString2 = IOUtil.readFileToString((File)bpelFile2);
        BPELScriptTestCase.assertEquals((String)bpelString, (String)bpelString2);
        String wsdlString = IOUtil.readFileToString((File)wsdlFile);
        String wsdlString2 = IOUtil.readFileToString((File)wsdlFile2);
        BPELScriptTestCase.assertEquals((String)wsdlString, (String)wsdlString2);
    }
}

