/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.scufl.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.workflow.model.graph.system.EndifNode;
import org.apache.airavata.workflow.model.graph.system.IfNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.MemoNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.impl.XmlElementWithViewsImpl;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.XmlNamespace;
import xsul.XmlConstants;
import xsul5.wsdl.WsdlMessage;
import xsul5.wsdl.WsdlMessagePart;
import xsul5.wsdl.WsdlPort;
import xsul5.wsdl.WsdlPortType;
import xsul5.wsdl.WsdlPortTypeOperation;
import xsul5.wsdl.WsdlService;

public class ScuflScript {
    private Workflow workflow;
    private XBayaConfiguration configuration;
    private WSGraph graph;
    private ArrayList<String> arguments;
    private List<InputNode> inputNodes;
    private List<OutputNode> outputNodes;
    private XmlInfosetBuilder builder = XmlConstants.BUILDER;
    private LinkedList<Node> notYetInvokedNodes;
    private LinkedList<Node> executingNodes;
    private XmlNamespace scuflNS = this.builder.newNamespace("s", "http://org.embl.ebi.escience/xscufl/0.1alpha");
    private Map<String, XmlElement> sources = new HashMap<String, XmlElement>();
    private List<XmlElement> links = new ArrayList<XmlElement>();
    private List<XmlElement> sinks = new ArrayList<XmlElement>();
    private XmlDocument script;

    public ScuflScript(Workflow workflow, XBayaConfiguration configuration) {
        this.workflow = workflow;
        this.configuration = configuration;
        this.graph = this.workflow.getGraph();
        this.arguments = new ArrayList();
        this.notYetInvokedNodes = new LinkedList();
        for (Node node : this.graph.getNodes()) {
            if (node instanceof MemoNode) continue;
            this.notYetInvokedNodes.add(node);
        }
        this.executingNodes = new LinkedList();
        this.inputNodes = GraphUtil.getInputNodes((Graph)this.graph);
        this.outputNodes = GraphUtil.getOutputNodes((Graph)this.graph);
    }

    public void create() throws GraphException {
        XmlDocument doc = this.builder.newDocument();
        XmlElement scufl = doc.addDocumentElement(this.scuflNS, "scufl");
        scufl.addAttribute("version", "0.2");
        scufl.addAttribute("log", "0");
        XmlElement description = scufl.addElement(this.scuflNS, "workflowdescription");
        description.addAttribute("lsid", "urn:lsid:net.sf.taverna:wfDefinition:" + UUID.randomUUID());
        description.addAttribute("author", "");
        description.addAttribute("title", this.workflow.getName());
        this.writeServices(scufl);
        this.writeSplitors(scufl);
        for (XmlElement link : this.links) {
            scufl.addElement(link);
        }
        for (String key : this.sources.keySet()) {
            scufl.addElement(this.sources.get(key));
        }
        for (XmlElement sink : this.sinks) {
            scufl.addElement(sink);
        }
        this.script = doc;
    }

    public String getScript() {
        return this.builder.serializeToString((Object)this.script);
    }

    private void writeSplitors(XmlElement scufl) throws GraphException {
        Collection<Node> nextNodes = this.getNextNodes();
        while (nextNodes.size() > 0) {
            for (Node node : nextNodes) {
                if (node instanceof WSNode) {
                    WSNode wsNode = (WSNode)node;
                    node.getInputPorts();
                    this.writeSplitorPerService(scufl, wsNode);
                }
                this.notYetInvokedNodes.remove(node);
                nextNodes = this.getNextNodes();
            }
        }
    }

    private void writeSplitorPerService(XmlElement scufl, WSNode node) throws GraphException {
        List inputPorts = node.getInputPorts();
        XmlElement processor = scufl.addElement(this.scuflNS, "processor");
        processor.addAttribute("name", this.getValidName(node) + "InputMessagePartXML");
        XmlElement local = processor.addElement(this.scuflNS, "local");
        local.addChild(0, (Object)"org.embl.ebi.escience.scuflworkers.java.XMLInputSplitter");
        XmlElement extensions = local.addElement(this.scuflNS, "extensions");
        QName inputName = this.getInputElementName(node);
        if (null == inputName) {
            throw new GraphException("No Valid input type found for WS Node" + node.getName());
        }
        if (node.getOutputPorts().size() != 1) {
            throw new GraphException("Number of out ports in WS node " + node.getName() + "is invalid:" + node.getOutputPorts().size());
        }
        DataPort outputPort = node.getOutputPort(0);
        WSComponent component = node.getComponent();
        String inputPartName = component.getInputPartName();
        String inputTypeName = component.getInputTypeName();
        XmlElement complexType = extensions.addElement(this.scuflNS, "complextype");
        complexType.addAttribute("optional", "false");
        complexType.addAttribute("unbounded", "false");
        complexType.addAttribute("typename", inputTypeName);
        String spliterName = inputPartName;
        complexType.addAttribute("name", spliterName);
        complexType.addAttribute("qname", inputName.toString());
        XmlElement element = complexType.addElement(this.scuflNS, "elements");
        for (DataPort port : inputPorts) {
            if ("http://www.w3.org/2001/XMLSchema".equals(port.getType().getNamespaceURI())) {
                XmlElement baseType = element.addElement(this.scuflNS, "basetype");
                baseType.addAttribute("optional", "false");
                baseType.addAttribute("unbounded", "false");
                baseType.addAttribute("typename", port.getType().getLocalPart());
                baseType.addAttribute("name", port.getName());
                baseType.addAttribute("qname", inputTypeName + "&gt;" + port.getName());
            }
            if (port.getFromNode() instanceof InputNode) {
                XmlElement source = this.builder.newFragment(this.scuflNS, "source");
                source.addAttribute("name", port.getFromNode().getID());
                if (!this.sourceExist(port.getFromNode().getID())) {
                    this.sources.put(port.getFromNode().getID(), source);
                }
                XmlElement link = this.builder.newFragment(this.scuflNS, "link");
                link.addAttribute("source", port.getFromNode().getID());
                link.addAttribute("sink", this.getValidName(node) + "InputMessagePartXML:" + port.getName());
                this.links.add(link);
                continue;
            }
            if (port.getFromNode() instanceof WSNode) {
                XmlElement link = this.builder.newFragment(this.scuflNS, "link");
                if (port.getFromNode().getOutputPorts().size() != 1) {
                    throw new GraphException("Number of out ports in from WS node " + port.getFromNode().getName() + "is invalid:" + node.getOutputPorts().size());
                }
                link.addAttribute("source", this.getValidName((WSNode)port.getFromNode()) + "OutputMessagePartXML:" + port.getFromNode().getOutputPort(0).getName());
                link.addAttribute("sink", this.getValidName(node) + "InputMessagePartXML:" + port.getName());
                this.links.add(link);
                continue;
            }
            throw new GraphException("Unhandled from node type:" + port.getFromNode() + " for node" + node.getName());
        }
        XmlElement link = this.builder.newFragment(this.scuflNS, "link");
        link.addAttribute("source", this.getValidName(node) + "InputMessagePartXML:output");
        link.addAttribute("sink", this.getValidName(node) + ":" + spliterName);
        this.links.add(link);
        link = this.builder.newFragment(this.scuflNS, "link");
        link.addAttribute("source", this.getValidName(node) + ":" + node.getComponent().getOutputPartName());
        link.addAttribute("sink", this.getValidName(node) + "OutputMessagePartXML:input");
        this.links.add(link);
        XmlElement outProcessor = scufl.addElement(this.scuflNS, "processor");
        outProcessor.addAttribute("name", this.getValidName(node) + "OutputMessagePartXML");
        XmlElement outLocal = outProcessor.addElement(this.scuflNS, "local");
        outLocal.addChild(0, (Object)"org.embl.ebi.escience.scuflworkers.java.XMLOutputSplitter");
        XmlElement outExtensions = outLocal.addElement(this.scuflNS, "extensions");
        XmlElement outComplextype = outExtensions.addElement(this.scuflNS, "complextype");
        outComplextype.addAttribute("optional", "false");
        outComplextype.addAttribute("unbounded", "false");
        outComplextype.addAttribute("typename", component.getOutputTypeName());
        outComplextype.addAttribute("name", component.getOutputPartName());
        QName outputName = this.getOutputElementName(node);
        if (null == outputName) {
            throw new GraphException("No Valid output type found for WS Node" + node.getName());
        }
        outComplextype.addAttribute("qname", outputName.toString());
        XmlElement elements = outComplextype.addElement(this.scuflNS, "elements");
        XmlElement outBaseType = elements.addElement(this.scuflNS, "basetype");
        outBaseType.addAttribute("optional", "false");
        outBaseType.addAttribute("unbounded", "false");
        outBaseType.addAttribute("typename", outputPort.getType().getLocalPart());
        String Z = component.getOutputPort(0).getName();
        outBaseType.addAttribute("name", Z);
        outBaseType.addAttribute("qname", component.getOutputTypeName() + "&gt;" + Z);
        List outputPorts = node.getOutputPorts();
        for (DataPort port : outputPorts) {
            List toNodes = port.getToNodes();
            for (Node toNode : toNodes) {
                if (!(toNode instanceof OutputNode) || !"http://www.w3.org/2001/XMLSchema".equals(port.getType().getNamespaceURI())) continue;
                XmlElement sink = this.builder.newFragment(this.scuflNS, "sink");
                sink.addAttribute("name", toNode.getID());
                this.sinks.add(sink);
                link = this.builder.newFragment(this.scuflNS, "link");
                link.addAttribute("source", this.getValidName(node) + "OutputMessagePartXML:" + outputPort.getName());
                link.addAttribute("sink", toNode.getID());
                this.links.add(link);
            }
        }
    }

    private boolean sourceExist(String name) {
        Set<String> keys = this.sources.keySet();
        for (String string : keys) {
            if (!name.equals(string)) continue;
            return true;
        }
        return false;
    }

    private QName getInputElementName(WSNode node) throws GraphException {
        WSComponent component = node.getComponent();
        String portTypeName = component.getPortTypeQName().getLocalPart();
        WsdlPortType portType = component.getWSDL().getPortType(portTypeName);
        WsdlPortTypeOperation operation = portType.getOperation(component.getOperationName());
        QName message = operation.getInput().getMessage();
        WsdlMessage wsdlMessage = component.getWSDL().getMessage(message.getLocalPart());
        Iterator iterator = wsdlMessage.parts().iterator();
        QName inputName = null;
        if (!iterator.hasNext()) {
            throw new GraphException("No input part found for WS Node" + node.getName());
        }
        inputName = ((WsdlMessagePart)iterator.next()).getElement();
        return inputName;
    }

    private QName getOutputElementName(WSNode node) throws GraphException {
        WSComponent component = node.getComponent();
        String portTypeName = component.getPortTypeQName().getLocalPart();
        WsdlPortType portType = component.getWSDL().getPortType(portTypeName);
        WsdlPortTypeOperation operation = portType.getOperation(component.getOperationName());
        QName message = operation.getOutput().getMessage();
        WsdlMessage wsdlMessage = component.getWSDL().getMessage(message.getLocalPart());
        Iterator iterator = wsdlMessage.parts().iterator();
        QName inputName = null;
        if (!iterator.hasNext()) {
            throw new GraphException("No output part found for WS Node" + node.getName());
        }
        inputName = ((WsdlMessagePart)iterator.next()).getElement();
        return inputName;
    }

    private void writeServices(XmlElement scufl) throws GraphException {
        List nextNodes = this.graph.getNodes();
        for (NodeImpl node : nextNodes) {
            if (!(node instanceof WSNode)) continue;
            WSNode wsNode = (WSNode)node;
            this.createWSProcess(wsNode, scufl);
        }
    }

    private XmlElement createWSProcess(WSNode node, XmlElement scufl) throws GraphException, XmlBuilderException {
        XmlElement processor = scufl.addElement(this.scuflNS, "processor");
        String name = this.getValidName(node);
        processor.addAttribute("name", name);
        XmlElement description = processor.addElement(this.scuflNS, "description");
        String txt = node.getComponent().getDescription();
        if (null == txt) {
            description.addChild((Object)name);
        } else {
            description.addChild((Object)txt);
        }
        XmlElement arbitrarywsdl = processor.addElement(this.scuflNS, "arbitrarywsdl");
        XmlElement wsdl = arbitrarywsdl.addElement(this.scuflNS, "wsdl");
        String epr = this.getEPR(node);
        if (null == epr) {
            throw new GraphException("EPR not found for the WS-node:" + this.builder.serializeToString((Object)node));
        }
        wsdl.addChild((Object)(epr + "?wsdl"));
        XmlElement operation = arbitrarywsdl.addElement(this.scuflNS, "operation");
        operation.addChild((Object)node.getOperationName());
        return processor;
    }

    private String getValidName(WSNode node) {
        return node.getID();
    }

    private String getEPR(WSNode wsNode) {
        Iterable ports;
        Iterator portIterator;
        Iterable services = wsNode.getComponent().getWSDL().services();
        Iterator iterator = services.iterator();
        if (iterator.hasNext() && (portIterator = (ports = ((WsdlService)iterator.next()).ports()).iterator()).hasNext()) {
            WsdlPort port = (WsdlPort)portIterator.next();
            Iterable children = port.xml().children();
            for (Object next : children) {
                if (!(next instanceof XmlElementWithViewsImpl)) continue;
                XmlAttribute epr = ((XmlElementWithViewsImpl)next).attribute("location");
                return epr.getValue();
            }
        }
        return null;
    }

    public boolean validate(List<String> warnings) {
        List constantNodes;
        if (this.graph.getNodes().size() == 0) {
            String message = "The workflow is empty.";
            warnings.add(message);
        }
        Collection inputPorts = GraphUtil.getPorts((Graph)this.graph, (Port.Kind)Port.Kind.DATA_IN);
        for (Port inputPort : inputPorts) {
            Collection fromPorts = inputPort.getFromPorts();
            if (fromPorts.size() != 0) continue;
            Node node = inputPort.getNode();
            String message = node.getID() + " has an unconnected input " + inputPort.getName();
            warnings.add(message);
        }
        for (InputNode inputNode : this.inputNodes) {
            if (inputNode.getPort().getToPorts().size() != 0) continue;
            String message = inputNode.getID() + " is not connected to any service.";
            warnings.add(message);
        }
        if (GraphUtil.containsCycle((Graph)this.graph)) {
            String message = "There is a cycle in the workflow.";
            warnings.add(message);
        }
        if ((constantNodes = GraphUtil.getNodes((Graph)this.graph, ConstantNode.class)).size() > 0) {
            String message = "Constants are not supported for Scufl scripts.";
            warnings.add(message);
        }
        List ifNodes = GraphUtil.getNodes((Graph)this.graph, IfNode.class);
        List endifNodes = GraphUtil.getNodes((Graph)this.graph, EndifNode.class);
        if (ifNodes.size() > 0 || endifNodes.size() > 0) {
            String message = "If/endif are not supported for Scufl scripts.";
            warnings.add(message);
        }
        return warnings.size() <= 0;
    }

    private Collection<Node> getNextNodes() throws GraphException {
        ArrayList<Node> nextNodes = new ArrayList<Node>();
        for (Node node : this.notYetInvokedNodes) {
            if (!this.isNextNode(node)) continue;
            nextNodes.add(node);
        }
        return nextNodes;
    }

    private boolean isNextNode(Node node) throws GraphException {
        if (node instanceof OutputNode) {
            return false;
        }
        for (Port port : node.getInputPorts()) {
            Collection fromNodes = port.getFromNodes();
            if (fromNodes.isEmpty()) {
                throw new GraphException("There is a port that is not connected to any.");
            }
            for (Node fromNode : fromNodes) {
                if (!this.notYetInvokedNodes.contains(fromNode)) continue;
                return false;
            }
        }
        ControlPort port = node.getControlInPort();
        if (port != null) {
            Collection fromNodes = port.getFromNodes();
            for (Node fromNode : fromNodes) {
                if (!this.notYetInvokedNodes.contains(fromNode)) continue;
                return false;
            }
        }
        return true;
    }
}

