/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.Arrays;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.exception.ServiceDescriptionRetrieveException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowTemplate;
import org.apache.airavata.xbaya.registry.RegistryAccesser;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;

public class XBayaWorkflowTemplateNode
extends AbstractAiravataTreeNode {
    private XBayaWorkflowTemplate xbayaWorkflow;

    public XBayaWorkflowTemplateNode(XBayaWorkflowTemplate xbayaWorkflow, TreeNode parent) {
        super(parent);
        this.setXbayaWorkflow(xbayaWorkflow);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.emptyList();
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.getXbayaWorkflow().getWorkflowName();
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.WORKFLOW_TEMPLATE_ICON;
    }

    public XBayaWorkflowTemplate getXbayaWorkflow() {
        return this.xbayaWorkflow;
    }

    public void setXbayaWorkflow(XBayaWorkflowTemplate xbayaWorkflow) {
        this.xbayaWorkflow = xbayaWorkflow;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.import", "action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            this.deleteHostDescription(tree);
            return true;
        }
        if (action.equals("action.import")) {
            Workflow workflow = new RegistryAccesser(this.getXBayaEngine()).getWorkflow(this.getXbayaWorkflow().getWorkflowName());
            GraphCanvas newGraphCanvas = this.getXBayaEngine().getGUI().newGraphCanvas(true);
            newGraphCanvas.setWorkflow(workflow);
            this.getXBayaEngine().getGUI().getGraphCanvas().setWorkflowFile(null);
            return true;
        }
        return super.triggerAction(tree, action);
    }

    private void deleteHostDescription(JTree tree) throws PathNotFoundException, ServiceDescriptionRetrieveException {
        if (this.askQuestion("XBaya Workflow", "Are you sure that you want to remove the workflow \"" + this.getXbayaWorkflow().getWorkflowName() + "\"?")) {
            try {
                this.getRegistry().getWorkflowManager().removeWorkflow(this.getXbayaWorkflow().getWorkflowName());
                ((AbstractAiravataTreeNode)this.getParent()).refresh();
                this.reloadTreeNode(tree, this.getParent());
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove";
        }
        if (action.getID().equals("action.import")) {
            return "Import";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getDefaultAction() {
        return "action.import";
    }
}

