/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.xbaya.model.registrybrowser.ServiceParameters;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowNodeElement;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;

public class XBayaWorkflowNodeElementNode
extends AbstractAiravataTreeNode {
    private XBayaWorkflowNodeElement xbayaWorkflowService;

    public XBayaWorkflowNodeElementNode(XBayaWorkflowNodeElement xbayaWorkflowNodeElement, TreeNode parent) {
        super(parent);
        this.setXbayaWorkflowNodeElement(xbayaWorkflowNodeElement);
    }

    @Override
    protected List<TreeNode> getChildren() {
        ArrayList<ServiceParameters> parameterTypeList = new ArrayList<ServiceParameters>();
        if (this.getXbayaWorkflowNodeElement().getInputParameters() != null && this.getXbayaWorkflowNodeElement().getInputParameters().getParameters().size() > 0) {
            parameterTypeList.add(this.getXbayaWorkflowNodeElement().getInputParameters());
        }
        if (this.getXbayaWorkflowNodeElement().getOutputParameters() != null && this.getXbayaWorkflowNodeElement().getOutputParameters().getParameters().size() > 0) {
            parameterTypeList.add(this.getXbayaWorkflowNodeElement().getOutputParameters());
        }
        return this.getTreeNodeList(parameterTypeList.toArray(), this);
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        String type = this.getXbayaWorkflowNodeElement().getNodeData().getType().toString();
        return this.wrapAsHtml(this.getXbayaWorkflowNodeElement().getNodeId(), " [", type, "]");
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.WORKFLOW_SERVICE_ICON;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList(new Object[0]);
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        return super.triggerAction(tree, action);
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    public XBayaWorkflowNodeElement getXbayaWorkflowNodeElement() {
        return this.xbayaWorkflowService;
    }

    public void setXbayaWorkflowNodeElement(XBayaWorkflowNodeElement xbayaWorkflowNodeElement) {
        this.xbayaWorkflowService = xbayaWorkflowNodeElement;
    }
}

