/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflow;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;

public class XBayaWorkflowNode
extends AbstractAiravataTreeNode {
    private XBayaWorkflow xbayaWorkflow;

    public XBayaWorkflowNode(XBayaWorkflow xbayaWorkflow, TreeNode parent) {
        super(parent);
        this.setXbayaWorkflow(xbayaWorkflow);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.getTreeNodeList(this.getXbayaWorkflow().getWorkflowServices().toArray(), this);
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        String caption = this.getXbayaWorkflow().getWorkflowId();
        if (this.getXbayaWorkflow().getWorkflowName() != null) {
            caption = this.getXbayaWorkflow().getWorkflowName() + " : " + caption;
        }
        return caption;
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.WORKFLOW_ICON;
    }

    public XBayaWorkflow getXbayaWorkflow() {
        return this.xbayaWorkflow;
    }

    public void setXbayaWorkflow(XBayaWorkflow xbayaWorkflow) {
        this.xbayaWorkflow = xbayaWorkflow;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.copy");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.copy")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getWorkflowInfo()), null);
        }
        return super.triggerAction(tree, action);
    }

    private String getWorkflowInfo() {
        String workflowName = this.getXbayaWorkflow().getWorkflowName();
        String workflowId = this.getXbayaWorkflow().getWorkflowId();
        return "[Worklfow Name = " + workflowName + ", Workflow Instance ID = " + workflowId + "]";
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.copy")) {
            return "Copy Workflow Info to clipboard";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }
}

