/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.workflow.ExperimentName;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowExperiment;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;

public class XBayaWorkflowExperimentNode
extends AbstractAiravataTreeNode {
    private XBayaWorkflowExperiment experiment;
    private String workflowExecutionName;

    public XBayaWorkflowExperimentNode(XBayaWorkflowExperiment experiment, TreeNode parent) {
        super(parent);
        this.setExperiment(experiment);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.getTreeNodeList(this.getExperiment().getWorkflows().toArray(), this);
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        if (this.workflowExecutionName == null) {
            try {
                this.workflowExecutionName = this.getRegistry().getProvenanceManager().getExperimentName(this.getExperiment().getExperimentId()).getInstanceName();
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
            if (this.workflowExecutionName == null) {
                this.workflowExecutionName = "[" + this.getExperiment().getExperimentId() + "]";
            }
        }
        String caption = this.workflowExecutionName;
        try {
            WorkflowExecutionStatus workflowExecutionStatus = this.getRegistry().getProvenanceManager().getWorkflowInstanceStatus(this.getExperiment().getExperimentId(), this.getExperiment().getExperimentId());
            if (workflowExecutionStatus != null && workflowExecutionStatus.getExecutionStatus() != null) {
                caption = caption + " - <i>" + workflowExecutionStatus.getExecutionStatus().toString() + "</i>";
                if (workflowExecutionStatus.getStatusUpdateTime() != null) {
                    caption = caption + "<i> as of " + workflowExecutionStatus.getStatusUpdateTime().toString() + "</i>";
                }
            }
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
        }
        return this.wrapAsHtml(caption);
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.WORKFLOW_EXPERIMENT_ICON;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.copy");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.copy")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getExperimentInfo()), null);
        }
        return super.triggerAction(tree, action);
    }

    private String getExperimentName() {
        String experimentId = this.getExperiment().getExperimentId();
        try {
            ExperimentName experimentName = this.getExperiment().getAiravataAPI().getProvenanceManager().getExperimentName(experimentId);
            return experimentName.getInstanceName();
        }
        catch (AiravataAPIInvocationException e) {
            return null;
        }
    }

    private String getExperimentInfo() {
        String experimetName = this.getExperimentName();
        String experimetID = this.getExperiment().getExperimentId();
        return "[Experiment Name = " + experimetName + ", Experiment ID = " + experimetID + "]";
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.copy")) {
            return "Copy Experiment Info to clipboard";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    public XBayaWorkflowExperiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(XBayaWorkflowExperiment experiment) {
        this.experiment = experiment;
    }
}

