/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.xbaya.model.registrybrowser.ServiceDescriptions;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.actions.registry.browser.RefreshAction;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.DeploymentDescriptionDialog;

public class ServiceDescriptionsNode
extends AbstractAiravataTreeNode {
    private ServiceDescriptions serviceDescriptions;

    public ServiceDescriptionsNode(ServiceDescriptions serviceDescriptions, TreeNode parent) {
        super(parent);
        this.setServiceDescriptions(serviceDescriptions);
    }

    @Override
    protected List<TreeNode> getChildren() {
        try {
            return this.getTreeNodeList(this.getServiceDescriptions().getDescriptions().toArray(), this);
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
            return this.emptyList();
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return this.emptyList();
        }
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return "Applications";
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.SERVICES_ICON;
    }

    public ServiceDescriptions getServiceDescriptions() {
        return this.serviceDescriptions;
    }

    public void setServiceDescriptions(ServiceDescriptions serviceDescriptions) {
        this.serviceDescriptions = serviceDescriptions;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.add", RefreshAction.ID, "action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            this.deleteServiceDescription(tree);
            return true;
        }
        if (action.equals("action.add")) {
            DeploymentDescriptionDialog serviceDescriptionDialog = new DeploymentDescriptionDialog(null, this.getRegistry());
            serviceDescriptionDialog.open();
            if (serviceDescriptionDialog.isServiceCreated()) {
                this.refresh();
                this.reloadTreeNode(tree, this);
            }
            return true;
        }
        return super.triggerAction(tree, action);
    }

    private void deleteServiceDescription(JTree tree) throws Exception {
        if (this.askQuestion("Applications", "Are you sure that you want to remove all applications defined in this registry?")) {
            AiravataAPI registry = this.getRegistry();
            List<ServiceDescription> descriptions = this.getServiceDescriptions().getDescriptions();
            for (ServiceDescription descriptionWrap : descriptions) {
                registry.getApplicationManager().deleteServiceDescription(descriptionWrap.getType().getName());
            }
            this.refresh();
            this.reloadTreeNode(tree, this);
        }
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove all Applicatons";
        }
        if (action.getID().equals("action.add")) {
            return "Register Application...";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }
}

