/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.schemas.gfac.Parameter;
import org.apache.airavata.xbaya.model.registrybrowser.ApplicationDeploymentDescriptions;
import org.apache.airavata.xbaya.model.registrybrowser.InputParameters;
import org.apache.airavata.xbaya.model.registrybrowser.OutputParameters;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.DeploymentDescriptionDialog;

public class ServiceDescriptionNode
extends AbstractAiravataTreeNode {
    private ServiceDescription serviceDescription;

    public ServiceDescriptionNode(ServiceDescription serviceDescription, TreeNode parent) {
        super(parent);
        this.setServiceDescription(serviceDescription);
    }

    @Override
    protected List<TreeNode> getChildren() {
        ArrayList<Object> parameterTypeList = new ArrayList<Object>();
        if (this.getServiceDescription().getType().getInputParametersArray().length > 0) {
            parameterTypeList.add(new InputParameters((Parameter[])this.getServiceDescription().getType().getInputParametersArray()));
        }
        if (this.getServiceDescription().getType().getOutputParametersArray().length > 0) {
            parameterTypeList.add(new OutputParameters((Parameter[])this.getServiceDescription().getType().getOutputParametersArray()));
        }
        parameterTypeList.add(new ApplicationDeploymentDescriptions(this.getRegistry(), this.getServiceDescription().getType().getName()));
        return this.getTreeNodeList(parameterTypeList.toArray(), this);
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.getServiceDescription().getType().getName();
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.SERVICE_ICON;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(ServiceDescription serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.edit", "action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            return this.deleteServiceDescription(tree);
        }
        if (action.equals("action.edit")) {
            return this.editServiceDescription(tree);
        }
        return super.triggerAction(tree, action);
    }

    private boolean editServiceDescription(JTree tree) {
        DeploymentDescriptionDialog serviceDescriptionDialog = new DeploymentDescriptionDialog(this.getRegistry(), false, this.getServiceDescription(), null);
        serviceDescriptionDialog.open();
        if (serviceDescriptionDialog.isServiceCreated()) {
            this.refresh();
            this.reloadTreeNode(tree, this);
        }
        return true;
    }

    private boolean deleteServiceDescription(JTree tree) throws AiravataAPIInvocationException {
        if (this.askQuestion("Application", "Are you sure that you want to remove the applications associated with \"" + this.getServiceDescription().getType().getName() + "\"?")) {
            this.getRegistry().getApplicationManager().deleteServiceDescription(this.getServiceDescription().getType().getName());
            ((AbstractAiravataTreeNode)this.getParent()).refresh();
            this.reloadTreeNode(tree, this.getParent());
        }
        return true;
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove";
        }
        if (action.getID().equals("action.edit")) {
            return "View/Edit";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getDefaultAction() {
        return "action.edit";
    }
}

