/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.model.registrybrowser.AiravataConfigurations;
import org.apache.airavata.xbaya.model.registrybrowser.HostDescriptions;
import org.apache.airavata.xbaya.model.registrybrowser.ServiceDescriptions;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowExperiments;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowTemplates;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.actions.registry.browser.RefreshAction;

public class RegistryNode
extends AbstractAiravataTreeNode {
    private AiravataAPI registry;
    private XBayaEngine engine;

    public RegistryNode(XBayaEngine engine, TreeNode parent) {
        super(parent);
        this.setRegistry(engine.getConfiguration().getAiravataAPI());
        this.engine = engine;
    }

    @Override
    protected List<TreeNode> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        AiravataConfigurations airavataConfigurations = new AiravataConfigurations(this.getRegistry());
        children.add(airavataConfigurations);
        HostDescriptions hostDescriptions = new HostDescriptions(this.getRegistry());
        children.add(hostDescriptions);
        ServiceDescriptions serviceDescriptions = new ServiceDescriptions(this.getRegistry());
        children.add(serviceDescriptions);
        XBayaWorkflowTemplates xBayaWorkflows = new XBayaWorkflowTemplates(this.getRegistry());
        children.add(xBayaWorkflows);
        XBayaWorkflowExperiments xBayaWorkflowExperiments = new XBayaWorkflowExperiments(this.getRegistry());
        children.add(xBayaWorkflowExperiments);
        return this.getTreeNodeList(children.toArray(), this);
    }

    @Override
    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        try {
            return this.getRegistry().getAiravataManager().getGateway().getGatewayName() + " - " + this.getRegistry().getAiravataManager().getUser().getUserName();
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.REGISTRY_ICON;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList(RefreshAction.ID);
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    public XBayaEngine getEngine() {
        return this.engine;
    }

    public void setEngine(XBayaEngine engine) {
        this.engine = engine;
    }
}

