/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.xbaya.model.registrybrowser.NodeParameter;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.dialogs.TextWindow;

public class ParameterNode
extends AbstractAiravataTreeNode {
    private NodeParameter parameter;

    public ParameterNode(NodeParameter parameter, TreeNode parent) {
        super(parent);
        this.setParameter(parameter);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.emptyList();
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        if (this.getParameter().getValue() != null) {
            String parameterValue = this.getParameter().getValue().toString();
            if (parameterValue.length() > 200) {
                parameterValue = parameterValue.substring(0, 200) + "...";
            }
            return this.wrapAsHtml("<b>" + this.getParameter().getName() + "</b>", ": ", "" + parameterValue + "");
        }
        return this.getParameter().getName();
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.PARAMETER_ICON;
    }

    @Override
    public String getDefaultAction() {
        return "action.view";
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.view", "action.copy");
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.view")) {
            return "View";
        }
        if (action.getID().equals("action.copy")) {
            return "Copy to clipboard";
        }
        return null;
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.view")) {
            TextWindow textWindow = new TextWindow(this.getXBayaEngine(), this.getParameter().getName(), this.getParameter().getValue().toString(), "Parameter Content");
            textWindow.show();
        } else if (action.equals("action.copy")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getParameter().getValue().toString()), null);
        }
        return super.triggerAction(tree, action);
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    public NodeParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(NodeParameter parameter) {
        this.parameter = parameter;
    }
}

