/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.xbaya.model.registrybrowser.HostDescriptions;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.actions.registry.browser.RefreshAction;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDescriptionDialog;

public class HostDescriptionsNode
extends AbstractAiravataTreeNode {
    private HostDescriptions hostDescriptions;

    public HostDescriptionsNode(HostDescriptions hostDescriptions, TreeNode parent) {
        super(parent);
        this.setHostDescriptions(hostDescriptions);
    }

    @Override
    protected List<TreeNode> getChildren() {
        try {
            return this.getTreeNodeList(this.getHostDescriptions().getDescriptions().toArray(), this);
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
            return this.emptyList();
        }
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return "Hosts";
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.HOSTS_ICON;
    }

    public HostDescriptions getHostDescriptions() {
        return this.hostDescriptions;
    }

    public void setHostDescriptions(HostDescriptions hostDescriptions) {
        this.hostDescriptions = hostDescriptions;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.add", RefreshAction.ID, "action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            this.deleteHostDescription(tree);
            return true;
        }
        if (action.equals("action.add")) {
            HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(this.getXBayaEngine().getConfiguration().getAiravataAPI(), null);
            hostDescriptionDialog.open();
            if (hostDescriptionDialog.isHostCreated()) {
                this.refresh();
                this.reloadTreeNode(tree, this);
            }
            return true;
        }
        return super.triggerAction(tree, action);
    }

    private void deleteHostDescription(JTree tree) throws Exception {
        if (this.askQuestion("Host descriptions", "Are you sure that you want to remove all host descriptions in this registry?")) {
            AiravataAPI registry = this.getRegistry();
            List<HostDescription> descriptions = this.getHostDescriptions().getDescriptions();
            for (HostDescription descriptionWrap : descriptions) {
                registry.getApplicationManager().removeHostDescriptor(descriptionWrap.getType().getHostName());
            }
            this.refresh();
            this.reloadTreeNode(tree, this);
        }
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove all hosts";
        }
        if (action.getID().equals("action.add")) {
            return "New host...";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }
}

