/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDescriptionDialog;

public class HostDescriptionNode
extends AbstractAiravataTreeNode {
    private HostDescription hostDescription;

    public HostDescriptionNode(HostDescription hostDescription, TreeNode parent) {
        super(parent);
        this.setHostDescription(hostDescription);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.emptyList();
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.getHostDescription().getType().getHostName();
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.HOST_ICON;
    }

    public HostDescription getHostDescription() {
        return this.hostDescription;
    }

    public void setHostDescription(HostDescription hostDescription) {
        this.hostDescription = hostDescription;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.edit", "action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            return this.deleteHostDescription(tree);
        }
        if (action.equals("action.edit")) {
            return this.editHostDescription(tree);
        }
        return super.triggerAction(tree, action);
    }

    @Override
    public String getDefaultAction() {
        return "action.edit";
    }

    private boolean editHostDescription(JTree tree) {
        HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(this.getXBayaEngine().getConfiguration().getAiravataAPI(), false, this.getHostDescription(), null);
        hostDescriptionDialog.open();
        if (hostDescriptionDialog.isHostCreated()) {
            this.refresh();
            this.reloadTreeNode(tree, this);
        }
        return true;
    }

    private boolean deleteHostDescription(JTree tree) throws AiravataAPIInvocationException {
        if (this.askQuestion("Host description", "Are you sure that you want to remove the host description \"" + this.getHostDescription().getType().getHostName() + "\"?")) {
            this.getRegistry().getApplicationManager().deleteHostDescription(this.getHostDescription().getType().getHostName());
            ((AbstractAiravataTreeNode)this.getParent()).refresh();
            this.reloadTreeNode(tree, this.getParent());
        }
        return true;
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove";
        }
        if (action.getID().equals("action.edit")) {
            return "View/Edit";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }
}

