/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.xbaya.model.registrybrowser.EventingServiceURL;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;

public class EventingServiceURLNode
extends AbstractAiravataTreeNode {
    private EventingServiceURL eventingServiceURL;

    public EventingServiceURLNode(EventingServiceURL eventingServiceURL, TreeNode parent) {
        super(parent);
        this.setEventingServiceURL(eventingServiceURL);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.emptyList();
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.getEventingServiceURL().getEventingServiceURL().toString();
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.GFAC_URL_ICON;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.copy");
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.copy")) {
            return "Copy to clipboard";
        }
        return null;
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.copy")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getEventingServiceURL().getEventingServiceURL().toString()), null);
        }
        return super.triggerAction(tree, action);
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }

    public EventingServiceURL getEventingServiceURL() {
        return this.eventingServiceURL;
    }

    public void setEventingServiceURL(EventingServiceURL eventingServiceURL) {
        this.eventingServiceURL = eventingServiceURL;
    }
}

