/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.xbaya.model.registrybrowser.ApplicationDeploymentDescriptionWrap;
import org.apache.airavata.xbaya.model.registrybrowser.ApplicationDeploymentDescriptions;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.actions.registry.browser.RefreshAction;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionDialog;

public class ApplicationDeploymentDescriptionsNode
extends AbstractAiravataTreeNode {
    private ApplicationDeploymentDescriptions applicationDeploymentDescriptions;

    public ApplicationDeploymentDescriptionsNode(ApplicationDeploymentDescriptions applicationDeploymentDescriptions, TreeNode parent) {
        super(parent);
        this.setApplicationDeploymentDescriptions(applicationDeploymentDescriptions);
    }

    @Override
    protected List<TreeNode> getChildren() {
        try {
            return this.getTreeNodeList(this.getApplicationDeploymentDescriptions().getDescriptions().toArray(), this);
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
            return this.emptyList();
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return this.emptyList();
        }
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return "Deployments";
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.APPLICATIONS_ICON;
    }

    public ApplicationDeploymentDescriptions getApplicationDeploymentDescriptions() {
        return this.applicationDeploymentDescriptions;
    }

    public void setApplicationDeploymentDescriptions(ApplicationDeploymentDescriptions applicationDeploymentDescriptions) {
        this.applicationDeploymentDescriptions = applicationDeploymentDescriptions;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList(RefreshAction.ID, "action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            this.deleteApplicationDescription(tree);
            return true;
        }
        if (action.equals("action.add")) {
            ApplicationDescriptionDialog applicationDescriptionDialog = new ApplicationDescriptionDialog(this.getXBayaEngine());
            applicationDescriptionDialog.open();
            if (applicationDescriptionDialog.isApplicationDescCreated()) {
                this.refresh();
                this.reloadTreeNode(tree, this);
            }
            return true;
        }
        return super.triggerAction(tree, action);
    }

    private void deleteApplicationDescription(JTree tree) throws Exception {
        if (this.askQuestion("Application descriptions", "Are you sure that you want to remove all application descriptions in this registry?")) {
            AiravataAPI airavataAPI = this.getRegistry();
            List<ApplicationDeploymentDescriptionWrap> descriptions = this.getApplicationDeploymentDescriptions().getDescriptions();
            for (ApplicationDeploymentDescriptionWrap descriptionWrap : descriptions) {
                airavataAPI.getApplicationManager().removeApplicationDescriptor(descriptionWrap.getService(), descriptionWrap.getHost(), descriptionWrap.getDescription().getType().getApplicationName().getStringValue());
            }
            this.refresh();
            this.reloadTreeNode(tree, this);
        }
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove all applications";
        }
        if (action.getID().equals("action.add")) {
            return "New application...";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }
}

