/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.xbaya.model.registrybrowser.ApplicationDeploymentDescriptionWrap;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionDialog;

public class ApplicationDeploymentDescriptionNode
extends AbstractAiravataTreeNode {
    private ApplicationDeploymentDescriptionWrap applicationDeploymentDescriptionWrap;

    public ApplicationDeploymentDescriptionNode(ApplicationDeploymentDescriptionWrap applicationDeploymentDescriptionWrap, TreeNode parent) {
        super(parent);
        this.setApplicationDeploymentDescriptionWrap(applicationDeploymentDescriptionWrap);
    }

    @Override
    protected List<TreeNode> getChildren() {
        return this.emptyList();
    }

    @Override
    public String getCaption(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.getApplicationDeploymentDescriptionWrap().getDescription().getType().getApplicationName().getStringValue();
    }

    @Override
    public Icon getIcon(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return JCRBrowserIcons.APPLICATION_ICON;
    }

    public ApplicationDeploymentDescriptionWrap getApplicationDeploymentDescriptionWrap() {
        return this.applicationDeploymentDescriptionWrap;
    }

    public void setApplicationDeploymentDescriptionWrap(ApplicationDeploymentDescriptionWrap applicationDeploymentDescriptionWrap) {
        this.applicationDeploymentDescriptionWrap = applicationDeploymentDescriptionWrap;
    }

    @Override
    public List<String> getSupportedActions() {
        return Arrays.asList("action.delete");
    }

    @Override
    public boolean triggerAction(JTree tree, String action) throws Exception {
        if (action.equals("action.delete")) {
            return this.deleteApplicationDescription(tree);
        }
        if (action.equals("action.edit")) {
            return this.editDescriptor(tree);
        }
        return super.triggerAction(tree, action);
    }

    private boolean editDescriptor(JTree tree) {
        ApplicationDescriptionDialog applicationDescriptionDialog = new ApplicationDescriptionDialog(this.getXBayaEngine(), false, this.getApplicationDeploymentDescriptionWrap().getDescription(), this.getApplicationDeploymentDescriptionWrap().getHost(), this.getApplicationDeploymentDescriptionWrap().getService());
        applicationDescriptionDialog.open();
        if (applicationDescriptionDialog.isApplicationDescCreated()) {
            this.refresh();
            this.reloadTreeNode(tree, this);
        }
        return true;
    }

    private boolean deleteApplicationDescription(JTree tree) throws AiravataAPIInvocationException {
        if (this.askQuestion("Application description", "Are you sure that you want to remove the application description \"" + this.getApplicationDeploymentDescriptionWrap().getDescription().getType().getApplicationName().getStringValue() + "\"?")) {
            this.getRegistry().getApplicationManager().deleteApplicationDescription(this.getApplicationDeploymentDescriptionWrap().getService(), this.getApplicationDeploymentDescriptionWrap().getHost(), this.getApplicationDeploymentDescriptionWrap().getDescription().getType().getApplicationName().getStringValue());
            ((AbstractAiravataTreeNode)this.getParent()).refresh();
            this.reloadTreeNode(tree, this.getParent());
        }
        return true;
    }

    @Override
    public String getActionCaption(AbstractBrowserActionItem action) {
        if (action.getID().equals("action.delete")) {
            return "Remove";
        }
        if (action.getID().equals("action.edit")) {
            return "View/Edit";
        }
        return action.getDefaultCaption();
    }

    @Override
    public Icon getActionIcon(AbstractBrowserActionItem action) {
        return null;
    }

    @Override
    public String getActionDescription(AbstractBrowserActionItem action) {
        return null;
    }
}

