/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registrybrowser.nodes;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.registrybrowser.nodes.AiravataTreeNodeFactory;
import org.apache.airavata.xbaya.registrybrowser.nodes.RegistryNode;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.actions.registry.browser.RefreshAction;

public abstract class AbstractAiravataTreeNode
implements TreeNode {
    private TreeNode parent;
    private Color backgroundSelectionColor;
    private DefaultTreeCellRenderer defaultCellRenderer = new DefaultTreeCellRenderer();
    private List<TreeNode> children;

    public AbstractAiravataTreeNode(TreeNode parent) {
        this.setParent(parent);
    }

    protected XBayaEngine getXBayaEngine() {
        TreeNode root = this.getRootNode();
        if (root instanceof RegistryNode) {
            return ((RegistryNode)root).getEngine();
        }
        return null;
    }

    public Enumeration children() {
        this.children = this.listOfChildren();
        Collections.enumeration(this.children);
        return Collections.enumeration(this.children);
    }

    protected abstract List<TreeNode> getChildren();

    private List<TreeNode> listOfChildren() {
        this.children = this.children == null ? this.getChildren() : this.children;
        return this.children;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.listOfChildren().size() > 0;
    }

    @Override
    public TreeNode getChildAt(int index) {
        return this.listOfChildren().get(index);
    }

    @Override
    public int getChildCount() {
        return this.listOfChildren().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.listOfChildren().indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.listOfChildren().size() == 0;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public abstract String getCaption(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract Icon getIcon(boolean var1, boolean var2, boolean var3, boolean var4);

    public void setBackgroundSelectionColor(Color c) {
        this.backgroundSelectionColor = c;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public Component getNodeComponent(boolean selected, boolean expanded, boolean leaf, boolean hasFocus) {
        return null;
    }

    public Component getNodeComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component nodeComponent = this.getNodeComponent(selected, expanded, leaf, hasFocus);
        if (nodeComponent == null && (nodeComponent = this.getDefaultCellRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus)) instanceof JLabel) {
            JLabel lbl = (JLabel)nodeComponent;
            lbl.setText(this.getCaption(selected, expanded, leaf, hasFocus));
            lbl.setIcon(this.getIcon(selected, expanded, leaf, hasFocus));
        }
        return nodeComponent;
    }

    protected DefaultTreeCellRenderer getDefaultCellRenderer() {
        return this.defaultCellRenderer;
    }

    protected List<TreeNode> getTreeNodeList(Object[] list, TreeNode parent) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Object o : list) {
            nodes.add(AiravataTreeNodeFactory.getTreeNode(o, parent));
        }
        return nodes;
    }

    protected List<TreeNode> emptyList() {
        return new ArrayList<TreeNode>();
    }

    public void refresh() {
        this.children = null;
    }

    public abstract List<String> getSupportedActions();

    public String getDefaultAction() {
        return null;
    }

    public boolean isActionSupported(AbstractBrowserActionItem action) {
        return this.getSupportedActions().contains(action.getID());
    }

    public boolean triggerAction(JTree tree, String action) throws Exception {
        return this.triggerAction(tree, action, false);
    }

    public boolean triggerAction(JTree tree, String action, boolean force) throws Exception {
        if (action.equals(RefreshAction.ID)) {
            this.refresh();
            ((DefaultTreeModel)tree.getModel()).reload(this);
            return true;
        }
        return false;
    }

    protected TreeNode getRootNode() {
        TreeNode rootNode = this;
        while (rootNode.getParent() != null) {
            rootNode = rootNode.getParent();
        }
        return rootNode;
    }

    public AiravataAPI getRegistry() {
        TreeNode rootNode = this.getRootNode();
        if (rootNode instanceof RegistryNode) {
            return ((RegistryNode)rootNode).getRegistry();
        }
        return null;
    }

    protected boolean askQuestion(String title, String question) {
        return JOptionPane.showConfirmDialog(null, question, title, 0) == 0;
    }

    protected void reloadTreeNode(JTree tree, TreeNode node) {
        TreePath selectionPath = tree.getSelectionPath();
        ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
        ((DefaultTreeModel)tree.getModel()).reload(node);
        tree.expandPath(selectionPath);
    }

    public abstract String getActionCaption(AbstractBrowserActionItem var1);

    public abstract Icon getActionIcon(AbstractBrowserActionItem var1);

    public abstract String getActionDescription(AbstractBrowserActionItem var1);

    protected String wrapAsHtml(String ... data) {
        String result = "<html>";
        for (String item : data) {
            result = result + item;
        }
        result = result + "</html>";
        return result;
    }
}

