/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.apache.airavata.xbaya.ui.experiment.RegistryWorkflowPublisherWindow;
import org.apache.airavata.xbaya.util.XBayaUtil;
import org.ietf.jgss.GSSCredential;
import org.xmlpull.infoset.XmlElement;

public class RegistryAccesser {
    public static final String PUBLIC_ACTOR = "public";
    private XBayaEngine engine;
    private GSSCredential gssCredential;

    public RegistryAccesser(XBayaEngine engine) {
        this.engine = engine;
    }

    private AiravataAPI connectToRegistry() {
        return this.engine.getConfiguration().getAiravataAPI();
    }

    public Map<String, String> getOGCEWorkflowTemplateList() throws AiravataAPIInvocationException {
        AiravataAPI airavataAPI = this.connectToRegistry();
        List workflows = airavataAPI.getWorkflowManager().getWorkflows();
        HashMap<String, String> workflowMap = new HashMap<String, String>();
        for (Workflow workflow : workflows) {
            workflowMap.put(workflow.getName(), airavataAPI.getWorkflowManager().getWorkflowAsString(workflow.getName()));
        }
        return workflowMap;
    }

    public Workflow getOGCEWorkflow(QName workflowTemplateId) throws RepositoryException, GraphException, ComponentException, Exception {
        AiravataAPI registry = this.connectToRegistry();
        String xml = registry.getWorkflowManager().getWorkflowAsString(workflowTemplateId.getLocalPart());
        XmlElement xwf = XMLUtil.stringToXmlElement((String)xml);
        Workflow workflow = new Workflow(xwf);
        return workflow;
    }

    public boolean saveWorkflow() {
        if (XBayaUtil.acquireJCRRegistry(this.engine)) {
            try {
                Workflow workflow = this.engine.getGUI().getWorkflow();
                JythonScript script = new JythonScript(workflow, this.engine.getConfiguration());
                ArrayList<String> warnings = new ArrayList<String>();
                if (!script.validate(warnings)) {
                    StringBuilder buf = new StringBuilder();
                    for (String warning : warnings) {
                        buf.append("- ");
                        buf.append(warning);
                        buf.append("\n");
                    }
                    this.engine.getGUI().getErrorWindow().warning(buf.toString());
                    return false;
                }
                RegistryWorkflowPublisherWindow registryPublishingWindow = new RegistryWorkflowPublisherWindow(this.engine);
                registryPublishingWindow.show();
                String workflowId = workflow.getName();
                workflowId = StringUtil.convertToJavaIdentifier((String)workflowId);
                QName workflowQName = new QName("http://workflow.ogce.org/", workflowId);
                String workflowAsString = XMLUtil.xmlElementToString((XmlElement)workflow.toXML());
                String owner = this.engine.getConfiguration().getRegistryUserName();
                AiravataAPI registry = this.connectToRegistry();
                if (registry.getWorkflowManager().isWorkflowExists(workflow.getName())) {
                    registry.getWorkflowManager().updateWorkflow(workflow.getName(), workflowAsString);
                } else {
                    registry.getWorkflowManager().saveWorkflow(workflowAsString);
                }
                if (registryPublishingWindow.isMakePublic()) {
                    registry.getWorkflowManager().publishWorkflow(workflow.getName());
                }
                registryPublishingWindow.hide();
                return true;
            }
            catch (Exception e) {
                this.engine.getGUI().getErrorWindow().error(e.getMessage(), e);
            }
        }
        return false;
    }

    public void deleteOGCEWorkflow(QName workflowTemplateId) throws AiravataAPIInvocationException {
        if (XBayaUtil.acquireJCRRegistry(this.engine)) {
            AiravataAPI registry = this.connectToRegistry();
            registry.getWorkflowManager().removeWorkflow(workflowTemplateId.getLocalPart());
        }
    }

    public Workflow getWorkflow(QName qname) throws AiravataAPIInvocationException {
        AiravataAPI registry = this.connectToRegistry();
        String xml = registry.getWorkflowManager().getWorkflowAsString(qname.getLocalPart());
        Workflow workflow = null;
        try {
            XmlElement xwf = XMLUtil.stringToXmlElement((String)xml);
            workflow = new Workflow(xwf);
        }
        catch (GraphException e) {
            e.printStackTrace();
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
        return workflow;
    }

    public Workflow getWorkflow(String name) throws AiravataAPIInvocationException {
        return this.getWorkflow(new QName("http://extreme.indiana.edu/lead/workflow", name));
    }

    public void main() {
        XBayaConfiguration config = new XBayaConfiguration();
        config.setMyProxyServer("myproxy.teragrid.org");
        config.setMyProxyUsername("USER");
        config.setMyProxyPassphrase("PASSWORD");
        new XBayaEngine(config);
    }
}

