/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.provenance;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStatusUpdater {
    private static Logger logger = LoggerFactory.getLogger(WorkflowStatusUpdater.class);
    private AiravataAPI airavataAPI;

    public WorkflowStatusUpdater(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }

    public boolean workflowStarted(String experimentID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(experimentID, experimentID, WorkflowExecutionStatus.State.STARTED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowFailed(String experimentID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(experimentID, experimentID, WorkflowExecutionStatus.State.FAILED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowFinished(String experimentID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(experimentID, experimentID, WorkflowExecutionStatus.State.FINISHED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowRunning(String experimentID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(experimentID, experimentID, WorkflowExecutionStatus.State.RUNNING);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowPaused(String experimentID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(experimentID, experimentID, WorkflowExecutionStatus.State.PAUSED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean saveWorkflowData(String experimentID, String workflowInstanceID, String workflowTemplateID) {
        Timestamp currentTime = new Timestamp(new Date().getTime());
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceTemplateName(workflowInstanceID, workflowTemplateID);
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(new WorkflowExecutionStatus(new WorkflowExecution(experimentID, workflowInstanceID), WorkflowExecutionStatus.State.STARTED, (Date)currentTime));
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error saving Workflow Data !!");
        }
        return true;
    }
}

